/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.handler.Asset;
import io.jooby.handler.AssetSource;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ClassPathAssetSource
implements AssetSource {
    private final ClassLoader loader;
    private final String source;
    private final boolean isDir;
    private final String prefix;

    public ClassPathAssetSource(ClassLoader loader, String source) {
        if (source == null || source.trim().length() == 0 || source.trim().equals("/")) {
            throw new IllegalArgumentException("For security reasons root classpath access is not allowed: " + source);
        }
        this.loader = loader;
        this.source = source.startsWith("/") ? source.substring(1) : source;
        this.prefix = this.sourcePrefix(this.source);
        this.isDir = this.isDirectory(loader, this.source);
    }

    @Override
    @Nullable
    public Asset resolve(@NonNull String path) {
        URL resource;
        Object fullpath;
        if (this.isDir) {
            fullpath = ClassPathAssetSource.safePath(this.prefix + path);
            if (!((String)fullpath).startsWith(this.prefix)) {
                return null;
            }
        } else {
            fullpath = this.source;
        }
        if ((resource = this.loader.getResource((String)fullpath)) == null) {
            return null;
        }
        Asset asset = Asset.create((String)fullpath, resource);
        if (asset.isDirectory()) {
            resource = this.loader.getResource((String)(fullpath = (String)fullpath + "/index.html"));
            asset = resource != null ? Asset.create((String)fullpath, resource) : null;
        }
        return asset;
    }

    private String sourcePrefix(String path) {
        if (path.length() > 0 && !path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDirectory(ClassLoader loader, String base) {
        boolean bl;
        URL url = loader.getResource(base);
        if (url == null) {
            return true;
        }
        URLConnection connection = url.openConnection();
        connection.setDefaultUseCaches(false);
        if (!(connection instanceof JarURLConnection)) return Files.isDirectory(Paths.get(url.toURI()), new LinkOption[0]);
        JarURLConnection jarConnection = (JarURLConnection)connection;
        JarFile jar = jarConnection.getJarFile();
        try {
            ZipEntry entry = jar.getEntry(base);
            bl = entry.isDirectory();
            if (jar == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jar == null) throw throwable;
                try {
                    jar.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception x) {
                return true;
            }
        }
        jar.close();
        return bl;
    }

    private static String safePath(String path) {
        if (path.indexOf("./") > 0) {
            return ClassPathAssetSource.normalize(path.split("/"));
        }
        return path;
    }

    private static String normalize(String[] segments) {
        Path path = Paths.get(segments[0], new String[0]);
        for (int i = 1; i < segments.length; ++i) {
            path = path.resolve(segments[i]);
        }
        StringBuilder buffer = new StringBuilder();
        for (Path segment : path.normalize()) {
            buffer.append("/").append(segment);
        }
        return buffer.substring(1);
    }
}

