/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.ValueNode;
import io.jooby.internal.MissingValue;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FileBody
implements Body {
    private Context ctx;
    private Path file;

    public FileBody(Context ctx, Path file) {
        this.ctx = ctx;
        this.file = file;
    }

    @Override
    public long getSize() {
        try {
            return Files.size(this.file);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    @NonNull
    public ReadableByteChannel channel() {
        try {
            return Files.newByteChannel(this.file, new OpenOption[0]);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    public InputStream stream() {
        try {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    public byte[] bytes() {
        try {
            return Files.readAllBytes(this.file);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    public String value() {
        return this.value(StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    public List<String> toList() {
        return Collections.singletonList(this.value());
    }

    @Override
    @NonNull
    public ValueNode get(int index) {
        return index == 0 ? this : this.get(Integer.toString(index));
    }

    @Override
    @NonNull
    public ValueNode get(@NonNull String name) {
        return new MissingValue(name);
    }

    @Override
    public String name() {
        return "body";
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Type type) {
        return this.ctx.decode(type, this.ctx.getRequestType(MediaType.text));
    }

    @Override
    @Nullable
    public <T> T toNullable(@NonNull Type type) {
        return this.ctx.decode(type, this.ctx.getRequestType(MediaType.text));
    }

    @Override
    @NonNull
    public Map<String, List<String>> toMultimap() {
        return Map.of();
    }
}

