/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.FlashMap;
import io.jooby.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class FlashMapImpl
extends HashMap<String, String>
implements FlashMap {
    private Context ctx;
    private boolean keep;
    private Cookie template;
    private Map<String, String> initialScope;

    public FlashMapImpl(Context ctx, Cookie template) {
        Value cookie = ctx.cookie(template.getName());
        Map seed = cookie.isMissing() ? Collections.emptyMap() : Cookie.decode(cookie.value());
        super.putAll(seed);
        this.ctx = ctx;
        this.template = template;
        this.initialScope = seed;
        if (seed.size() > 0) {
            this.syncCookie();
        }
    }

    @Override
    public FlashMap keep() {
        if (this.size() > 0) {
            Cookie cookie = this.template.clone().setValue(Cookie.encode(this));
            this.ctx.setResponseCookie(cookie);
        }
        return this;
    }

    private Cookie toCookie() {
        if (this.equals(this.initialScope)) {
            if (this.size() > 0) {
                return this.template.clone().setMaxAge(0L);
            }
        } else {
            if (this.size() == 0) {
                return this.template.clone().setMaxAge(0L);
            }
            return this.template.clone().setValue(Cookie.encode(this));
        }
        return null;
    }

    private void syncCookie() {
        Cookie cookie = this.toCookie();
        if (cookie != null) {
            this.ctx.setResponseCookie(cookie);
        }
    }

    @Override
    public String compute(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        String result = super.compute(key, remappingFunction);
        this.syncCookie();
        return result;
    }

    @Override
    public String computeIfAbsent(String key, Function<? super String, ? extends String> mappingFunction) {
        String result = super.computeIfAbsent(key, mappingFunction);
        this.syncCookie();
        return result;
    }

    @Override
    public String computeIfPresent(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        String result = super.computeIfPresent(key, remappingFunction);
        this.syncCookie();
        return result;
    }

    @Override
    public String merge(String key, String value, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        String result = super.merge(key, value, remappingFunction);
        this.syncCookie();
        return result;
    }

    @Override
    public String put(String key, String value) {
        String result = super.put(key, value);
        this.syncCookie();
        return result;
    }

    @Override
    public String putIfAbsent(String key, String value) {
        String result = super.putIfAbsent(key, value);
        this.syncCookie();
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        super.putAll(m);
        this.syncCookie();
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result = super.remove(key, value);
        this.syncCookie();
        return result;
    }

    @Override
    public String remove(Object key) {
        String result = (String)super.remove(key);
        this.syncCookie();
        return result;
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        boolean result = super.replace(key, oldValue, newValue);
        this.syncCookie();
        return result;
    }

    @Override
    public String replace(String key, String value) {
        String result = super.replace(key, value);
        this.syncCookie();
        return result;
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super String, ? extends String> function) {
        super.replaceAll(function);
        this.syncCookie();
    }
}

