/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Route;
import io.jooby.StatusCode;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongUnaryOperator;

public class GracefulShutdownHandler
implements Route.Filter {
    private static final long SHUTDOWN_MASK = Long.MIN_VALUE;
    private static final long ACTIVE_COUNT_MASK = Long.MAX_VALUE;
    private static final LongUnaryOperator incrementActive = current -> {
        long incrementedActiveCount = GracefulShutdownHandler.activeCount(current) + 1L;
        return incrementedActiveCount | current & Long.MIN_VALUE;
    };
    private static final LongUnaryOperator incrementActiveAndShutdown = incrementActive.andThen(current -> current | Long.MIN_VALUE);
    private static final LongUnaryOperator decrementActive = current -> {
        long decrementedActiveCount = GracefulShutdownHandler.activeCount(current) - 1L;
        return decrementedActiveCount | current & Long.MIN_VALUE;
    };
    private final Object lock = new Object();
    private final Duration await;
    private volatile long state = 0L;
    private static final AtomicLongFieldUpdater<GracefulShutdownHandler> stateUpdater = AtomicLongFieldUpdater.newUpdater(GracefulShutdownHandler.class, "state");

    public GracefulShutdownHandler(Duration await) {
        this.await = await;
    }

    @Override
    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return ctx -> {
            long snapshot = stateUpdater.updateAndGet(this, incrementActive);
            if (GracefulShutdownHandler.isShutdown(snapshot)) {
                this.decrementRequests();
                return ctx.send(StatusCode.SERVICE_UNAVAILABLE);
            }
            ctx.onComplete(context -> this.decrementRequests());
            return next.apply(ctx);
        };
    }

    private static boolean isShutdown(long state) {
        return (state & Long.MIN_VALUE) != 0L;
    }

    private static long activeCount(long state) {
        return state & Long.MAX_VALUE;
    }

    public void shutdown() throws InterruptedException {
        stateUpdater.updateAndGet(this, incrementActiveAndShutdown);
        this.decrementRequests();
        if (this.await == null) {
            this.awaitShutdown();
        } else {
            this.awaitShutdown(this.await.toMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            stateUpdater.updateAndGet(this, current -> current & Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownComplete() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitShutdown() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!GracefulShutdownHandler.isShutdown(stateUpdater.get(this))) {
                return;
            }
            while (GracefulShutdownHandler.activeCount(stateUpdater.get(this)) > 0L) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitShutdown(long millis) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!GracefulShutdownHandler.isShutdown(stateUpdater.get(this))) {
                return false;
            }
            long end = System.currentTimeMillis() + millis;
            while (GracefulShutdownHandler.activeCount(stateUpdater.get(this)) != 0L) {
                long left = end - System.currentTimeMillis();
                if (left <= 0L) {
                    return false;
                }
                this.lock.wait(left);
            }
            return true;
        }
    }

    private void decrementRequests() {
        long snapshot = stateUpdater.updateAndGet(this, decrementActive);
        if (snapshot == Long.MIN_VALUE) {
            this.shutdownComplete();
        }
    }
}

