/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.FileDownload;
import io.jooby.MediaType;
import io.jooby.MessageEncoder;
import io.jooby.ModelAndView;
import io.jooby.StatusCode;
import io.jooby.TemplateEngine;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HttpMessageEncoder
implements MessageEncoder {
    private Map<MediaType, MessageEncoder> encoders;
    private final LinkedList<TemplateEngine> templateEngineList = new LinkedList();

    public HttpMessageEncoder add(MediaType type, MessageEncoder encoder) {
        if (encoder instanceof TemplateEngine) {
            TemplateEngine engine = (TemplateEngine)encoder;
            this.templateEngineList.add(engine);
        } else {
            if (this.encoders == null) {
                this.encoders = new LinkedHashMap<MediaType, MessageEncoder>();
            }
            this.encoders.put(type, encoder);
        }
        return this;
    }

    @Override
    public DataBuffer encode(@NonNull Context ctx, @NonNull Object value) throws Exception {
        if (value instanceof ModelAndView) {
            ModelAndView modelAndView = (ModelAndView)value;
            for (TemplateEngine engine : this.templateEngineList) {
                if (!engine.supports(modelAndView)) continue;
                return engine.encode(ctx, modelAndView);
            }
            throw new IllegalArgumentException("No template engine for: " + modelAndView.getView());
        }
        if (value instanceof InputStream) {
            ctx.send((InputStream)value);
            return null;
        }
        if (value instanceof StatusCode) {
            ctx.send((StatusCode)value);
            return null;
        }
        if (value instanceof FileChannel) {
            ctx.send((FileChannel)value);
            return null;
        }
        if (value instanceof File) {
            ctx.send(((File)value).toPath());
            return null;
        }
        if (value instanceof Path) {
            ctx.send((Path)value);
            return null;
        }
        if (value instanceof FileDownload) {
            ctx.send((FileDownload)value);
            return null;
        }
        DataBufferFactory bufferFactory = ctx.getBufferFactory();
        if (value instanceof CharSequence) {
            return bufferFactory.wrap(value.toString().getBytes(StandardCharsets.UTF_8));
        }
        if (value instanceof Number) {
            return bufferFactory.wrap(value.toString().getBytes(StandardCharsets.UTF_8));
        }
        if (value instanceof byte[]) {
            return bufferFactory.wrap((byte[])value);
        }
        if (value instanceof ByteBuffer) {
            ctx.send((ByteBuffer)value);
            return null;
        }
        if (this.encoders != null) {
            List<MediaType> produces = ctx.getRoute().getProduces();
            if (produces.isEmpty()) {
                produces = new ArrayList<MediaType>(this.encoders.keySet());
            }
            MediaType type = ctx.accept(produces);
            MessageEncoder encoder = this.encoders.getOrDefault(type, MessageEncoder.TO_STRING);
            return encoder.encode(ctx, value);
        }
        return MessageEncoder.TO_STRING.encode(ctx, value);
    }
}

