/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Jooby;
import io.jooby.LoggingService;
import io.jooby.Server;
import io.jooby.ServerOptions;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MutedServer
implements Server {
    private Server delegate;
    private List<String> mute;
    private LoggingService loggingService;

    private MutedServer(Server server, LoggingService loggingService, List<String> mute) {
        this.delegate = server;
        this.loggingService = loggingService;
        this.mute = mute;
    }

    public static Server mute(Server server, String ... logger2) {
        if (server instanceof MutedServer) {
            return server;
        }
        List<String> mute = Stream.concat(server.getLoggerOff().stream(), Stream.of(logger2)).collect(Collectors.toList());
        Optional<LoggingService> loggingService = ServiceLoader.load(LoggingService.class, server.getClass().getClassLoader()).findFirst();
        if (loggingService.isEmpty()) {
            return server;
        }
        return mute.isEmpty() ? server : new MutedServer(server, loggingService.get(), mute);
    }

    @Override
    @NonNull
    public Server setOptions(@NonNull ServerOptions options) {
        return this.delegate.setOptions(options);
    }

    @Override
    @NonNull
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    @NonNull
    public ServerOptions getOptions() {
        return this.delegate.getOptions();
    }

    @Override
    @NonNull
    public Server start(@NonNull Jooby application) {
        this.loggingService.logOff(this.mute, () -> this.delegate.start(application));
        return this.delegate;
    }

    @Override
    @NonNull
    public List<String> getLoggerOff() {
        return this.delegate.getLoggerOff();
    }

    @Override
    @NonNull
    public Server stop() {
        this.loggingService.logOff(this.mute, this.delegate::stop);
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

