/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.ValueNode;
import io.jooby.internal.MissingValue;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SingleValue
implements ValueNode {
    private final Context ctx;
    private final String name;
    private String value;

    public SingleValue(Context ctx, String name, String value) {
        this.ctx = ctx;
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @NonNull
    public ValueNode get(int index) {
        return index == 0 ? this : this.get(Integer.toString(index));
    }

    @Override
    @NonNull
    public ValueNode get(@NonNull String name) {
        return new MissingValue(this.name + "." + name);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Iterator<ValueNode> iterator() {
        return Collections.singletonList(this).iterator();
    }

    @Override
    @NonNull
    public <T> List<T> toList(@NonNull Class<T> type) {
        return Collections.singletonList(this.to(type));
    }

    @Override
    @NonNull
    public <T> Set<T> toSet(@NonNull Class<T> type) {
        return Collections.singleton(this.to(type));
    }

    @Override
    @NonNull
    public <T> Optional<T> toOptional(@NonNull Class<T> type) {
        return Optional.of(this.to(type));
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Class<T> type) {
        return this.ctx.convert(this, type);
    }

    @Override
    @Nullable
    public <T> T toNullable(@NonNull Class<T> type) {
        return this.ctx.convertOrNull(this, type);
    }

    @Override
    public Map<String, List<String>> toMultimap() {
        return Collections.singletonMap(this.name, Collections.singletonList(this.value));
    }

    @Override
    public List<String> toList() {
        return Collections.singletonList(this.value);
    }

    @Override
    public Set<String> toSet() {
        return Collections.singleton(this.value);
    }
}

