/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.handler.Asset;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class URLAsset
implements Asset {
    private final URL resource;
    private final String path;
    private long len;
    private long lastModified;
    private InputStream content;

    public URLAsset(@NonNull URL resource, @NonNull String path) {
        this.resource = resource;
        this.path = path;
    }

    @Override
    public long getSize() {
        this.checkOpen();
        return this.len;
    }

    @Override
    public long getLastModified() {
        this.checkOpen();
        return this.lastModified;
    }

    @Override
    @NonNull
    public MediaType getContentType() {
        return MediaType.byFile(this.path);
    }

    @Override
    public InputStream stream() {
        this.checkOpen();
        return this.content;
    }

    @Override
    public void close() {
        try {
            if (this.content != null) {
                this.content.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.content = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof URLAsset) {
            return this.path.equals(((URLAsset)obj).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    @Override
    public boolean isDirectory() {
        return this.getSize() == 0L;
    }

    private void checkOpen() {
        try {
            if (this.content == null) {
                URLConnection connection = this.resource.openConnection();
                connection.setUseCaches(false);
                this.len = connection.getContentLengthLong();
                this.lastModified = connection.getLastModified();
                this.content = connection.getInputStream();
            }
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }
}

