/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.BeanConverter;
import io.jooby.Router;
import io.jooby.ValueConverter;
import io.jooby.ValueNode;
import io.jooby.internal.converter.BigDecimalConverter;
import io.jooby.internal.converter.BigIntegerConverter;
import io.jooby.internal.converter.CharsetConverter;
import io.jooby.internal.converter.DateConverter;
import io.jooby.internal.converter.DurationConverter;
import io.jooby.internal.converter.InstantConverter;
import io.jooby.internal.converter.LocalDateConverter;
import io.jooby.internal.converter.LocalDateTimeConverter;
import io.jooby.internal.converter.PeriodConverter;
import io.jooby.internal.converter.ReflectiveBeanConverter;
import io.jooby.internal.converter.StatusCodeConverter;
import io.jooby.internal.converter.StringConstructorConverter;
import io.jooby.internal.converter.TimeZoneConverter;
import io.jooby.internal.converter.URIConverter;
import io.jooby.internal.converter.UUIDConverter;
import io.jooby.internal.converter.ValueOfConverter;
import io.jooby.internal.converter.ZoneIdConverter;
import io.jooby.internal.reflect.$Types;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ValueConverters {
    public static List<ValueConverter> defaultConverters() {
        return List.of(new UUIDConverter(), new InstantConverter(), new DateConverter(), new LocalDateConverter(), new LocalDateTimeConverter(), new BigDecimalConverter(), new BigIntegerConverter(), new DurationConverter(), new PeriodConverter(), new CharsetConverter(), new StatusCodeConverter(), new TimeZoneConverter(), new ZoneIdConverter(), new URIConverter(), new ValueOfConverter(), new StringConstructorConverter());
    }

    public static <T> T convert(ValueNode value, Type type, Router router) {
        Class<?> rawType = $Types.getRawType(type);
        if (List.class.isAssignableFrom(rawType)) {
            return (T)Collections.singletonList(ValueConverters.convert(value, $Types.parameterizedType0(type), router));
        }
        if (Set.class.isAssignableFrom(rawType)) {
            return (T)Collections.singleton(ValueConverters.convert(value, $Types.parameterizedType0(type), router));
        }
        if (Optional.class.isAssignableFrom(rawType)) {
            return (T)Optional.ofNullable(ValueConverters.convert(value, $Types.parameterizedType0(type), router));
        }
        return ValueConverters.convert(value, rawType, router, false);
    }

    public static <T> T convert(ValueNode value, Class type, Router router, boolean allowEmptyBean) {
        if (type == String.class) {
            return (T)value.valueOrNull();
        }
        if (type == Integer.TYPE) {
            return (T)Integer.valueOf(value.intValue());
        }
        if (type == Long.TYPE) {
            return (T)Long.valueOf(value.longValue());
        }
        if (type == Float.TYPE) {
            return (T)Float.valueOf(value.floatValue());
        }
        if (type == Double.TYPE) {
            return (T)Double.valueOf(value.doubleValue());
        }
        if (type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value.booleanValue());
        }
        if (type == Byte.TYPE) {
            return (T)Byte.valueOf(value.byteValue());
        }
        if (Enum.class.isAssignableFrom(type)) {
            return (T)ValueConverters.enumValue(value, type);
        }
        if (type == Integer.class) {
            return (T)(value.isMissing() ? null : Integer.valueOf(value.intValue()));
        }
        if (type == Long.class) {
            return (T)(value.isMissing() ? null : Long.valueOf(value.longValue()));
        }
        if (type == Float.class) {
            return (T)(value.isMissing() ? null : Float.valueOf(value.floatValue()));
        }
        if (type == Double.class) {
            return (T)(value.isMissing() ? null : Double.valueOf(value.doubleValue()));
        }
        if (type == Byte.class) {
            return (T)(value.isMissing() ? null : Byte.valueOf(value.byteValue()));
        }
        if (value.isSingle()) {
            for (ValueConverter converter : router.getConverters()) {
                if (!converter.supports(type)) continue;
                return (T)converter.convert(value, type);
            }
        } else if (value.isObject()) {
            for (BeanConverter converter : router.getBeanConverters()) {
                if (!converter.supports(type)) continue;
                return (T)converter.convert(value, type);
            }
        }
        ReflectiveBeanConverter reflective = new ReflectiveBeanConverter();
        return (T)reflective.convert(value, type, allowEmptyBean);
    }

    private static Object enumValue(ValueNode value, Class type) {
        try {
            return Enum.valueOf(type, value.value().toUpperCase());
        }
        catch (IllegalArgumentException x) {
            String name = value.value();
            EnumSet<Enum> enums = EnumSet.allOf(type);
            for (Enum e : enums) {
                if (!e.name().equalsIgnoreCase(name)) continue;
                return e;
            }
            throw x;
        }
    }
}

