/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.DefaultContext;
import io.jooby.ForwardingContext;
import io.jooby.MediaType;
import io.jooby.WebSocketMessage;
import io.jooby.internal.ByteArrayBody;
import java.lang.reflect.Type;

public class WebSocketMessageImpl
extends ByteArrayBody
implements WebSocketMessage {
    public WebSocketMessageImpl(Context ctx, byte[] bytes) {
        super(ctx, bytes);
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Type type) {
        MediaType contentType = this.ctx.getRoute().getConsumes().get(0);
        return new WebSocketMessageBody(this.ctx, this).decode(type, contentType);
    }

    @Override
    @Nullable
    public <T> T toNullable(@NonNull Type type) {
        return this.to(type);
    }

    private static class WebSocketMessageBody
    extends ForwardingContext
    implements DefaultContext {
        private final Body body;

        public WebSocketMessageBody(@NonNull Context context, Body body) {
            super(context);
            this.body = body;
        }

        @Override
        @NonNull
        public Body body() {
            return this.body;
        }

        @Override
        @NonNull
        public <T> T body(@NonNull Type type) {
            return this.body.to(type);
        }

        @Override
        @NonNull
        public <T> T body(@NonNull Class<T> type) {
            return this.body.to(type);
        }

        @Override
        @NonNull
        public <T> T decode(@NonNull Type type, @NonNull MediaType contentType) {
            return DefaultContext.super.decode(type, contentType);
        }
    }
}

