/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.converter;

import io.jooby.Value;
import io.jooby.ValueConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CharsetConverter
implements ValueConverter {
    @Override
    public boolean supports(Class type) {
        return type == Charset.class;
    }

    public Object convert(Value value, Class type) {
        String charset = value.value();
        switch (charset.toLowerCase()) {
            case "utf-8": {
                return StandardCharsets.UTF_8;
            }
            case "us-ascii": {
                return StandardCharsets.US_ASCII;
            }
            case "iso-8859-1": {
                return StandardCharsets.ISO_8859_1;
            }
            case "utf-16": {
                return StandardCharsets.UTF_16;
            }
            case "utf-16be": {
                return StandardCharsets.UTF_16BE;
            }
            case "utf-16le": {
                return StandardCharsets.UTF_16LE;
            }
        }
        return Charset.forName(charset);
    }
}

