/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.converter;

import io.jooby.Value;
import io.jooby.ValueConverter;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateConverter
implements ValueConverter {
    @Override
    public boolean supports(Class type) {
        return type == Date.class;
    }

    public Object convert(Value value, Class type) {
        try {
            return new Date(Long.parseLong(value.value()));
        }
        catch (NumberFormatException x) {
            LocalDate date = LocalDate.parse(value.value(), DateTimeFormatter.ISO_LOCAL_DATE);
            return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }
}

