/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.converter;

import io.jooby.Value;
import io.jooby.ValueConverter;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class InstantConverter
implements ValueConverter {
    @Override
    public boolean supports(Class type) {
        return type == Instant.class;
    }

    public Object convert(Value value, Class type) {
        try {
            return Instant.ofEpochMilli(Long.parseLong(value.value()));
        }
        catch (NumberFormatException x) {
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)value.value(), Instant::from);
        }
    }
}

