/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.converter;

import io.jooby.Value;
import io.jooby.ValueConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeConverter
implements ValueConverter {
    @Override
    public boolean supports(Class type) {
        return type == LocalDateTime.class;
    }

    public Object convert(Value value, Class type) {
        try {
            Instant instant = Instant.ofEpochMilli(Long.parseLong(value.value()));
            return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (NumberFormatException x) {
            return LocalDateTime.parse(value.value(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
    }
}

