/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.converter;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.SneakyThrows;
import io.jooby.Usage;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.annotation.EmptyBean;
import io.jooby.exception.BadRequestException;
import io.jooby.exception.ProvisioningException;
import io.jooby.internal.reflect.$Types;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class ReflectiveBeanConverter {
    private static final String AMBIGUOUS_CONSTRUCTOR = "Ambiguous constructor found. Expecting a single constructor or only one annotated with " + Inject.class.getName();
    private static final Object[] NO_ARGS = new Object[0];

    public Object convert(@NonNull ValueNode node, @NonNull Class type, boolean allowEmptyBean) {
        try {
            return ReflectiveBeanConverter.newInstance(type, node, allowEmptyBean);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException x) {
            throw SneakyThrows.propagate(x);
        }
        catch (InvocationTargetException x) {
            throw SneakyThrows.propagate(x.getCause());
        }
    }

    private static Object newInstance(Class type, ValueNode node, boolean allowEmptyBean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Constructor[] constructors2 = type.getConstructors();
        HashSet<ValueNode> state = new HashSet<ValueNode>();
        Constructor constructor = constructors2.length == 0 ? type.getDeclaredConstructor(new Class[0]) : ReflectiveBeanConverter.selectConstructor(constructors2);
        Object[] args2 = constructor.getParameterCount() == 0 ? NO_ARGS : ReflectiveBeanConverter.inject(node, constructor, state::add);
        List<Setter> setters = ReflectiveBeanConverter.setters(type, node, state);
        if (!ReflectiveBeanConverter.allowEmptyBean(type, allowEmptyBean) && state.stream().allMatch(Value::isMissing)) {
            return null;
        }
        Object instance = constructor.newInstance(args2);
        for (Setter setter : setters) {
            setter.invoke(instance);
        }
        return instance;
    }

    private static boolean allowEmptyBean(Class type, boolean defaults) {
        return type.getAnnotation(EmptyBean.class) == null ? defaults : true;
    }

    private static Constructor selectConstructor(Constructor[] constructors2) {
        Constructor result;
        if (constructors2.length == 1) {
            return constructors2[0];
        }
        Constructor injectConstructor = null;
        Constructor defaultConstructor = null;
        for (Constructor constructor : constructors2) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            Inject inject = constructor.getAnnotation(Inject.class);
            if (inject == null) {
                if (constructor.getParameterCount() != 0) continue;
                defaultConstructor = constructor;
                continue;
            }
            if (injectConstructor == null) {
                injectConstructor = constructor;
                continue;
            }
            throw new IllegalStateException(AMBIGUOUS_CONSTRUCTOR);
        }
        Constructor constructor = result = injectConstructor == null ? defaultConstructor : injectConstructor;
        if (result == null) {
            throw new IllegalStateException(AMBIGUOUS_CONSTRUCTOR);
        }
        return result;
    }

    public static Object[] inject(ValueNode scope, Executable method, Consumer<ValueNode> state) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return NO_ARGS;
        }
        Object[] args2 = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String name = ReflectiveBeanConverter.paramName(parameter);
            ValueNode param = scope.get(name);
            Object arg = ReflectiveBeanConverter.value(parameter, scope, param);
            if (arg == null) {
                state.accept(Value.missing(name));
            } else {
                state.accept(param);
            }
            args2[i] = arg;
        }
        return args2;
    }

    private static String paramName(Parameter parameter) {
        Named named = parameter.getAnnotation(Named.class);
        if (named != null && named.value().length() > 0) {
            return named.value();
        }
        if (parameter.isNamePresent()) {
            return parameter.getName();
        }
        throw Usage.parameterNameNotPresent(parameter);
    }

    private static Set<String> names(ValueNode node) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (ValueNode item : node) {
            names.add(item.name());
        }
        if (node instanceof Formdata) {
            for (FileUpload file : ((Formdata)node).files()) {
                names.add(file.getName());
            }
        }
        return names;
    }

    private static List<Setter> setters(Class type, ValueNode node, Set<ValueNode> nodes) {
        Method[] methods2 = type.getMethods();
        ArrayList<Setter> result = new ArrayList<Setter>();
        for (String name : ReflectiveBeanConverter.names(node)) {
            ValueNode value = node.get(name);
            if (!nodes.add(value)) continue;
            Method method = ReflectiveBeanConverter.findSetter(methods2, name);
            if (method != null) {
                Parameter parameter = method.getParameters()[0];
                try {
                    Object arg = ReflectiveBeanConverter.value(parameter, node, value);
                    result.add(new Setter(method, arg));
                    continue;
                }
                catch (ProvisioningException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new ProvisioningException(parameter, (Throwable)x);
                }
            }
            nodes.remove(value);
        }
        return result;
    }

    private static Object value(Parameter parameter, ValueNode node, ValueNode value) {
        try {
            if (ReflectiveBeanConverter.isFileUpload(node, parameter)) {
                Formdata formdata = (Formdata)node;
                if (Set.class.isAssignableFrom(parameter.getType())) {
                    return new HashSet<FileUpload>(formdata.files(value.name()));
                }
                if (Collection.class.isAssignableFrom(parameter.getType())) {
                    return formdata.files(value.name());
                }
                if (Optional.class.isAssignableFrom(parameter.getType())) {
                    List<FileUpload> files = formdata.files(value.name());
                    return files.isEmpty() ? Optional.empty() : Optional.of(files.get(0));
                }
                return formdata.file(value.name());
            }
            if (Set.class.isAssignableFrom(parameter.getType())) {
                return value.toSet($Types.parameterizedType0(parameter.getParameterizedType()));
            }
            if (Collection.class.isAssignableFrom(parameter.getType())) {
                return value.toList($Types.parameterizedType0(parameter.getParameterizedType()));
            }
            if (Optional.class.isAssignableFrom(parameter.getType())) {
                return value.toOptional($Types.parameterizedType0(parameter.getParameterizedType()));
            }
            if (ReflectiveBeanConverter.isNullable(parameter)) {
                String str;
                if (value.isSingle() && ((str = value.valueOrNull()) == null || str.length() == 0)) {
                    return null;
                }
                return value.toNullable(parameter.getType());
            }
            return value.to(parameter.getType());
        }
        catch (BadRequestException x) {
            throw new ProvisioningException(parameter, (Throwable)x);
        }
    }

    private static boolean isNullable(Parameter parameter) {
        Class<?> type = parameter.getType();
        if (ReflectiveBeanConverter.hasAnnotation(parameter, ".Nullable")) {
            return true;
        }
        boolean nonnull = ReflectiveBeanConverter.hasAnnotation(parameter, ".NonNull");
        if (nonnull) {
            return false;
        }
        return !type.isPrimitive();
    }

    private static boolean hasAnnotation(AnnotatedElement element, String ... names) {
        List<String> nameList = List.of(names);
        for (Annotation annotation : element.getAnnotations()) {
            if (!nameList.stream().anyMatch(name -> annotation.annotationType().getSimpleName().endsWith((String)name))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileUpload(ValueNode node, Parameter parameter) {
        return node instanceof Formdata && ReflectiveBeanConverter.isFileUpload(parameter.getType()) || ReflectiveBeanConverter.isFileUpload($Types.parameterizedType0(parameter.getParameterizedType()));
    }

    private static boolean isFileUpload(Class type) {
        return FileUpload.class == type;
    }

    private static Method findSetter(Method[] methods2, String name) {
        String setter = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        LinkedList<Method> candidates = new LinkedList<Method>();
        for (Method method : methods2) {
            if (!method.getName().equals(name) && !method.getName().equals(setter) || method.getParameterCount() != 1) continue;
            if (method.getName().startsWith("set")) {
                candidates.addFirst(method);
                continue;
            }
            candidates.addLast(method);
        }
        return candidates.isEmpty() ? null : (Method)candidates.getFirst();
    }

    private record Setter(Method method, Object arg) {
        public void invoke(Object instance) throws InvocationTargetException, IllegalAccessException {
            this.method.invoke(instance, this.arg);
        }
    }
}

