/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.x509;

import io.jooby.internal.x509.JdkSslContext;
import java.io.InputStream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;

public final class JdkSslServerContext
extends JdkSslContext {
    private final SSLContext ctx;

    public JdkSslServerContext(String provider, InputStream trustCertChainFile, InputStream keyCertChainFile, InputStream keyFile, String keyPassword, long sessionCacheSize, long sessionTimeout) throws SSLException {
        try {
            TrustManagerFactory trustManagerFactory = null;
            if (trustCertChainFile != null) {
                trustManagerFactory = JdkSslServerContext.buildTrustManagerFactory(trustCertChainFile, trustManagerFactory);
            }
            KeyManagerFactory keyManagerFactory = JdkSslServerContext.buildKeyManagerFactory(keyCertChainFile, keyFile, keyPassword);
            this.ctx = provider == null ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", provider);
            this.ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), null);
            SSLSessionContext sessCtx = this.ctx.getServerSessionContext();
            if (sessionCacheSize > 0L) {
                sessCtx.setSessionCacheSize((int)Math.min(sessionCacheSize, Integer.MAX_VALUE));
            }
            if (sessionTimeout > 0L) {
                sessCtx.setSessionTimeout((int)Math.min(sessionTimeout, Integer.MAX_VALUE));
            }
        }
        catch (Exception e) {
            throw new SSLException("failed to initialize the server-side SSL context", e);
        }
    }

    @Override
    public SSLContext context() {
        return this.ctx;
    }
}

