/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.x509;

import io.jooby.internal.x509.JdkSslServerContext;
import io.jooby.internal.x509.PemReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

public abstract class SslContext {
    static final CertificateFactory X509_CERT_FACTORY;

    public static SslContext newServerContextInternal(String provider, InputStream trustCertChainFile, InputStream keyCertChainFile, InputStream keyFile, String keyPassword, long sessionCacheSize, long sessionTimeout) throws SSLException {
        return new JdkSslServerContext(provider, trustCertChainFile, keyCertChainFile, keyFile, keyPassword, sessionCacheSize, sessionTimeout);
    }

    public abstract long sessionCacheSize();

    public abstract long sessionTimeout();

    public abstract SSLContext context();

    public abstract SSLSessionContext sessionContext();

    protected static PKCS8EncodedKeySpec generateKeySpec(char[] password, byte[] key) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (password == null || password.length == 0) {
            return new PKCS8EncodedKeySpec(key);
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKey pbeKey = keyFactory.generateSecret(pbeKeySpec);
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        cipher.init(2, (Key)pbeKey, encryptedPrivateKeyInfo.getAlgParameters());
        return encryptedPrivateKeyInfo.getKeySpec(cipher);
    }

    static KeyStore buildKeyStore(InputStream certChainFile, InputStream keyFile, char[] keyPasswordChars) throws KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, CertificateException, KeyException, IOException {
        PrivateKey key;
        ByteBuffer encodedKeyBuf = PemReader.readPrivateKey(keyFile);
        byte[] encodedKey = encodedKeyBuf.array();
        PKCS8EncodedKeySpec encodedKeySpec = SslContext.generateKeySpec(keyPasswordChars, encodedKey);
        try {
            key = KeyFactory.getInstance("RSA").generatePrivate(encodedKeySpec);
        }
        catch (InvalidKeySpecException ignore) {
            try {
                key = KeyFactory.getInstance("DSA").generatePrivate(encodedKeySpec);
            }
            catch (InvalidKeySpecException ignore2) {
                try {
                    key = KeyFactory.getInstance("EC").generatePrivate(encodedKeySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", e);
                }
            }
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        List<ByteBuffer> certs = PemReader.readCertificates(certChainFile);
        ArrayList<Certificate> certChain = new ArrayList<Certificate>(certs.size());
        for (ByteBuffer buf : certs) {
            certChain.add(cf.generateCertificate(new ByteArrayInputStream(buf.array())));
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("key", key, keyPasswordChars, certChain.toArray(new Certificate[0]));
        return ks;
    }

    protected static TrustManagerFactory buildTrustManagerFactory(InputStream certChainFile, TrustManagerFactory trustManagerFactory) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        List<ByteBuffer> certs = PemReader.readCertificates(certChainFile);
        for (ByteBuffer buf : certs) {
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(buf.array()));
            X500Principal principal = cert.getSubjectX500Principal();
            ks.setCertificateEntry(principal.getName("RFC2253"), cert);
        }
        if (trustManagerFactory == null) {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        trustManagerFactory.init(ks);
        return trustManagerFactory;
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("unable to instance X.509 CertificateFactory", e);
        }
    }
}

