/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.validation;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.ForwardingContext;
import io.jooby.QueryString;
import io.jooby.ValueNode;
import io.jooby.validation.BeanValidator;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ValidationContext
extends ForwardingContext {
    public ValidationContext(@NonNull Context context) {
        super(context);
    }

    @Override
    @NonNull
    public <T> T body(@NonNull Type type) {
        return this.body().to(type);
    }

    @Override
    @NonNull
    public <T> T body(@NonNull Class<T> type) {
        return this.body().to(type);
    }

    @Override
    @NonNull
    public ValueNode path() {
        return new ValidatedValue(this.ctx, super.path());
    }

    @Override
    @NonNull
    public Body body() {
        return new ValidatedBody(this.ctx, super.body());
    }

    @Override
    @NonNull
    public <T> T query(@NonNull Class<T> type) {
        return this.query().to(type);
    }

    @Override
    @NonNull
    public QueryString query() {
        return new ValidatedQueryString(this.ctx, super.query());
    }

    @Override
    @NonNull
    public <T> T form(@NonNull Class<T> type) {
        return this.form().to(type);
    }

    @Override
    @NonNull
    public Formdata form() {
        return new ValidatedFormdata(this.ctx, super.form());
    }

    @Override
    @NonNull
    public ValueNode header() {
        return new ValidatedValue(this.ctx, super.header());
    }

    public static class ValidatedValue
    extends ForwardingContext.ForwardingValueNode {
        protected final Context ctx;

        public ValidatedValue(Context ctx, ValueNode delegate) {
            super(delegate);
            this.ctx = ctx;
        }

        @Override
        @NonNull
        public <T> T to(@NonNull Class<T> type) {
            return BeanValidator.apply(this.ctx, super.toNullable(type));
        }

        @Override
        @Nullable
        public <T> T toNullable(@NonNull Class<T> type) {
            return BeanValidator.apply(this.ctx, super.toNullable(type));
        }

        @Override
        @NonNull
        public <T> List<T> toList(@NonNull Class<T> type) {
            return BeanValidator.apply(this.ctx, super.toList(type));
        }

        @Override
        @NonNull
        public <T> Set<T> toSet(@NonNull Class<T> type) {
            return BeanValidator.apply(this.ctx, super.toSet(type));
        }
    }

    public static class ValidatedBody
    extends ValidatedValue
    implements Body {
        public ValidatedBody(Context ctx, Body body) {
            super(ctx, body);
        }

        @Override
        @NonNull
        public byte[] bytes() {
            return ((Body)this.delegate).bytes();
        }

        @Override
        public boolean isInMemory() {
            return ((Body)this.delegate).isInMemory();
        }

        @Override
        public long getSize() {
            return ((Body)this.delegate).getSize();
        }

        @Override
        @NonNull
        public ReadableByteChannel channel() {
            return ((Body)this.delegate).channel();
        }

        @Override
        @NonNull
        public InputStream stream() {
            return ((Body)this.delegate).stream();
        }

        @Override
        @NonNull
        public <T> T to(@NonNull Type type) {
            return BeanValidator.apply(this.ctx, ((Body)this.delegate).toNullable(type));
        }

        @Override
        @Nullable
        public <T> T toNullable(@NonNull Type type) {
            return BeanValidator.apply(this.ctx, ((Body)this.delegate).toNullable(type));
        }
    }

    public static class ValidatedQueryString
    extends ValidatedValue
    implements QueryString {
        public ValidatedQueryString(Context ctx, QueryString delegate) {
            super(ctx, delegate);
        }

        @Override
        @NonNull
        public String queryString() {
            return ((QueryString)this.delegate).queryString();
        }
    }

    public static class ValidatedFormdata
    extends ValidatedValue
    implements Formdata {
        public ValidatedFormdata(Context ctx, Formdata delegate) {
            super(ctx, delegate);
        }

        @Override
        public void put(@NonNull String path, @NonNull ValueNode value) {
            ((Formdata)this.delegate).put(path, value);
        }

        @Override
        public void put(@NonNull String path, @NonNull String value) {
            ((Formdata)this.delegate).put(path, value);
        }

        @Override
        public void put(@NonNull String path, @NonNull Collection<String> values2) {
            ((Formdata)this.delegate).put(path, values2);
        }

        @Override
        public void put(@NonNull String name, @NonNull FileUpload file) {
            ((Formdata)this.delegate).put(name, file);
        }

        @Override
        @NonNull
        public List<FileUpload> files() {
            return ((Formdata)this.delegate).files();
        }

        @Override
        @NonNull
        public List<FileUpload> files(@NonNull String name) {
            return ((Formdata)this.delegate).files(name);
        }

        @Override
        @NonNull
        public FileUpload file(@NonNull String name) {
            return ((Formdata)this.delegate).file(name);
        }
    }
}

