/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.validation;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.StatusCode;
import io.jooby.problem.HttpProblem;
import io.jooby.problem.HttpProblemMappable;
import io.jooby.validation.JsonPointer;
import java.util.LinkedList;
import java.util.List;

public class ValidationResult
implements HttpProblemMappable {
    private String title;
    private int status;
    private List<Error> errors;

    public ValidationResult() {
    }

    public ValidationResult(String title, int status, List<Error> errors) {
        this.title = title;
        this.status = status;
        this.errors = errors;
    }

    @Override
    @NonNull
    public HttpProblem toHttpProblem() {
        return HttpProblem.builder().title(this.title).status(StatusCode.valueOf(this.status)).detail(this.errors.size() + " constraint violation(s) detected").errors(this.convertErrors()).build();
    }

    private List<HttpProblem.Error> convertErrors() {
        LinkedList<HttpProblem.Error> problemErrors = new LinkedList<HttpProblem.Error>();
        for (Error err : this.errors) {
            for (String msg : err.messages()) {
                problemErrors.add(new HttpProblem.Error(msg, JsonPointer.of(err.field)));
            }
        }
        return problemErrors;
    }

    public String getTitle() {
        return this.title;
    }

    public int getStatus() {
        return this.status;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public record Error(String field, List<String> messages, ErrorType type) {
    }

    public static enum ErrorType {
        FIELD,
        GLOBAL;

    }
}

