/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeHealthChecker;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.WorkerUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.XnioSsl;

class NodePingUtil {
    NodePingUtil() {
    }

    static void pingHost(InetSocketAddress address, HttpServerExchange exchange, PingCallback callback, OptionMap options) {
        XnioIoThread thread2 = exchange.getIoThread();
        XnioWorker worker = thread2.getWorker();
        HostPingTask r = new HostPingTask(address, worker, callback, options);
        NodePingUtil.scheduleCancelTask(exchange.getIoThread(), r, 5L, TimeUnit.SECONDS);
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : thread2, r);
    }

    static void pingHttpClient(URI connection, PingCallback callback, HttpServerExchange exchange, UndertowClient client, XnioSsl xnioSsl, OptionMap options) {
        XnioIoThread thread2 = exchange.getIoThread();
        RequestExchangeListener exchangeListener = new RequestExchangeListener(callback, NodeHealthChecker.NO_CHECK, true);
        HttpClientPingTask r = new HttpClientPingTask(connection, exchangeListener, thread2, client, xnioSsl, exchange.getConnection().getByteBufferPool(), options);
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : thread2, r);
        NodePingUtil.scheduleCancelTask(exchange.getIoThread(), exchangeListener, 5L, TimeUnit.SECONDS);
    }

    static void pingNode(final Node node, final HttpServerExchange exchange, final PingCallback callback) {
        if (node == null) {
            callback.failed();
            return;
        }
        final int timeout = node.getNodeConfig().getPing();
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : exchange.getIoThread(), new Runnable(){

            @Override
            public void run() {
                node.getConnectionPool().connect(null, exchange, new ProxyCallback<ProxyConnection>(){

                    @Override
                    public void completed(HttpServerExchange exchange, ProxyConnection result) {
                        RequestExchangeListener exchangeListener = new RequestExchangeListener(callback, NodeHealthChecker.NO_CHECK, false);
                        exchange.dispatch(SameThreadExecutor.INSTANCE, new ConnectionPoolPingTask(result, exchangeListener, node.getNodeConfig().getConnectionURI()));
                        NodePingUtil.scheduleCancelTask(exchange.getIoThread(), exchangeListener, timeout, TimeUnit.SECONDS);
                    }

                    @Override
                    public void failed(HttpServerExchange exchange) {
                        callback.failed();
                    }

                    @Override
                    public void queuedRequestFailed(HttpServerExchange exchange) {
                        callback.failed();
                    }

                    @Override
                    public void couldNotResolveBackend(HttpServerExchange exchange) {
                        callback.failed();
                    }
                }, timeout, TimeUnit.SECONDS, false);
            }
        });
    }

    static void internalPingNode(Node node, PingCallback callback, NodeHealthChecker healthChecker, XnioIoThread ioThread, ByteBufferPool bufferPool, UndertowClient client, XnioSsl xnioSsl, OptionMap options) {
        URI uri = node.getNodeConfig().getConnectionURI();
        long timeout = node.getNodeConfig().getPing();
        RequestExchangeListener exchangeListener = new RequestExchangeListener(callback, healthChecker, true);
        HttpClientPingTask r = new HttpClientPingTask(uri, exchangeListener, ioThread, client, xnioSsl, bufferPool, options);
        NodePingUtil.scheduleCancelTask(ioThread, exchangeListener, timeout, TimeUnit.SECONDS);
        ioThread.execute(r);
    }

    static void scheduleCancelTask(XnioIoThread ioThread, final CancellableTask cancellable, long timeout, TimeUnit timeUnit) {
        XnioExecutor.Key key = WorkerUtils.executeAfter(ioThread, new Runnable(){

            @Override
            public void run() {
                cancellable.cancel();
            }
        }, timeout, timeUnit);
        cancellable.setCancelKey(key);
    }

    static class CancellableTask {
        private final PingCallback delegate;
        private volatile State state = State.WAITING;
        private volatile XnioExecutor.Key cancelKey;

        CancellableTask(PingCallback callback) {
            this.delegate = callback;
        }

        boolean isDone() {
            return this.state != State.WAITING;
        }

        void setCancelKey(XnioExecutor.Key cancelKey) {
            if (this.state == State.WAITING) {
                this.cancelKey = cancelKey;
            } else {
                cancelKey.remove();
            }
        }

        void taskCompleted() {
            if (this.state == State.WAITING) {
                this.state = State.DONE;
                if (this.cancelKey != null) {
                    this.cancelKey.remove();
                }
                this.delegate.completed();
            }
        }

        void taskFailed() {
            if (this.state == State.WAITING) {
                this.state = State.DONE;
                if (this.cancelKey != null) {
                    this.cancelKey.remove();
                }
                this.delegate.failed();
            }
        }

        void cancel() {
            if (this.state == State.WAITING) {
                this.state = State.CANCELLED;
                if (this.cancelKey != null) {
                    this.cancelKey.remove();
                }
                this.delegate.failed();
            }
        }
    }

    static enum State {
        WAITING,
        DONE,
        CANCELLED;

    }

    static class RequestExchangeListener
    extends CancellableTask
    implements ClientCallback<ClientExchange> {
        private ClientExchange exchange;
        private final boolean closeConnection;
        private final NodeHealthChecker healthChecker;

        RequestExchangeListener(PingCallback callback, NodeHealthChecker healthChecker, boolean closeConnection) {
            super(callback);
            assert (healthChecker != null);
            this.closeConnection = closeConnection;
            this.healthChecker = healthChecker;
        }

        @Override
        public void completed(final ClientExchange result) {
            if (this.isDone()) {
                IoUtils.safeClose((Closeable)result.getConnection());
                return;
            }
            ChannelListener<StreamSourceChannel> listener = ChannelListeners.drainListener(Long.MAX_VALUE, new ChannelListener<StreamSourceChannel>(){

                @Override
                public void handleEvent(StreamSourceChannel channel) {
                    try {
                        if (healthChecker.checkResponse(result.getResponse())) {
                            this.taskCompleted();
                        } else {
                            this.taskFailed();
                        }
                    }
                    finally {
                        if (closeConnection && exchange != null) {
                            IoUtils.safeClose((Closeable)exchange.getConnection());
                        }
                    }
                }
            }, new ChannelExceptionHandler<StreamSourceChannel>(){

                @Override
                public void handleException(StreamSourceChannel channel, IOException exception) {
                    this.taskFailed();
                    if (exception != null) {
                        IoUtils.safeClose((Closeable)exchange.getConnection());
                    }
                }
            });
            StreamSourceChannel responseChannel = result.getResponseChannel();
            responseChannel.getReadSetter().set(listener);
            responseChannel.resumeReads();
            listener.handleEvent(responseChannel);
        }

        @Override
        public void failed(IOException e) {
            this.taskFailed();
            if (this.exchange != null) {
                IoUtils.safeClose((Closeable)this.exchange.getConnection());
            }
        }
    }

    static class HttpClientPingTask
    implements Runnable {
        private final URI connection;
        private final XnioIoThread thread;
        private final UndertowClient client;
        private final XnioSsl xnioSsl;
        private final ByteBufferPool bufferPool;
        private final OptionMap options;
        private final RequestExchangeListener exchangeListener;

        HttpClientPingTask(URI connection, RequestExchangeListener exchangeListener, XnioIoThread thread2, UndertowClient client, XnioSsl xnioSsl, ByteBufferPool bufferPool, OptionMap options) {
            this.connection = connection;
            this.thread = thread2;
            this.client = client;
            this.xnioSsl = xnioSsl;
            this.bufferPool = bufferPool;
            this.options = options;
            this.exchangeListener = exchangeListener;
        }

        @Override
        public void run() {
            UndertowLogger.ROOT_LOGGER.httpClientPingTask(this.connection);
            this.client.connect(new ClientCallback<ClientConnection>(){

                @Override
                public void completed(final ClientConnection clientConnection) {
                    if (exchangeListener.isDone()) {
                        IoUtils.safeClose((Closeable)clientConnection);
                        return;
                    }
                    ClientRequest request = new ClientRequest();
                    request.setMethod(Methods.OPTIONS);
                    request.setPath("*");
                    request.getRequestHeaders().add(Headers.USER_AGENT, "mod_cluster ping").add(Headers.HOST, connection.getHost());
                    clientConnection.sendRequest(request, new ClientCallback<ClientExchange>(){

                        @Override
                        public void completed(ClientExchange result) {
                            exchangeListener.exchange = result;
                            if (exchangeListener.isDone()) {
                                return;
                            }
                            result.setResponseListener(exchangeListener);
                            try {
                                result.getRequestChannel().shutdownWrites();
                                if (!result.getRequestChannel().flush()) {
                                    result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<StreamSinkChannel>(){

                                        @Override
                                        public void handleException(StreamSinkChannel channel, IOException exception) {
                                            IoUtils.safeClose((Closeable)clientConnection);
                                            exchangeListener.taskFailed();
                                        }
                                    }));
                                    result.getRequestChannel().resumeWrites();
                                }
                            }
                            catch (IOException e) {
                                IoUtils.safeClose((Closeable)clientConnection);
                                exchangeListener.taskFailed();
                            }
                        }

                        @Override
                        public void failed(IOException e) {
                            exchangeListener.taskFailed();
                            IoUtils.safeClose((Closeable)clientConnection);
                        }
                    });
                }

                @Override
                public void failed(IOException e) {
                    exchangeListener.taskFailed();
                }
            }, this.connection, this.thread, this.xnioSsl, this.bufferPool, this.options);
        }
    }

    static class HostPingTask
    extends CancellableTask
    implements Runnable {
        private final InetSocketAddress address;
        private final XnioWorker worker;
        private final OptionMap options;

        HostPingTask(InetSocketAddress address, XnioWorker worker, PingCallback callback, OptionMap options) {
            super(callback);
            this.address = address;
            this.worker = worker;
            this.options = options;
        }

        @Override
        public void run() {
            try {
                IoFuture<StreamConnection> future = this.worker.openStreamConnection(this.address, (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

                    @Override
                    public void handleEvent(StreamConnection channel) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }, this.options);
                future.addNotifier(new IoFuture.HandlingNotifier<StreamConnection, Void>(){

                    @Override
                    public void handleCancelled(Void attachment) {
                        this.cancel();
                    }

                    @Override
                    public void handleFailed(IOException exception, Void attachment) {
                        this.taskFailed();
                    }

                    @Override
                    public void handleDone(StreamConnection data, Void attachment) {
                        this.taskCompleted();
                    }
                }, null);
            }
            catch (Exception e) {
                this.taskFailed();
            }
        }
    }

    static class ConnectionPoolPingTask
    implements Runnable {
        private final RequestExchangeListener exchangeListener;
        private final ProxyConnection proxyConnection;
        private final URI uri;

        ConnectionPoolPingTask(ProxyConnection proxyConnection, RequestExchangeListener exchangeListener, URI uri) {
            this.proxyConnection = proxyConnection;
            this.exchangeListener = exchangeListener;
            this.uri = uri;
        }

        @Override
        public void run() {
            ClientRequest request = new ClientRequest();
            request.setMethod(Methods.OPTIONS);
            request.setPath("*");
            request.getRequestHeaders().add(Headers.USER_AGENT, "mod_cluster ping").add(Headers.HOST, this.uri.getHost());
            this.proxyConnection.getConnection().sendRequest(request, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(ClientExchange result) {
                    if (exchangeListener.isDone()) {
                        IoUtils.safeClose((Closeable)proxyConnection.getConnection());
                        return;
                    }
                    exchangeListener.exchange = result;
                    result.setResponseListener(exchangeListener);
                    try {
                        result.getRequestChannel().shutdownWrites();
                        if (!result.getRequestChannel().flush()) {
                            result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<StreamSinkChannel>(){

                                @Override
                                public void handleException(StreamSinkChannel channel, IOException exception) {
                                    IoUtils.safeClose((Closeable)proxyConnection.getConnection());
                                    exchangeListener.taskFailed();
                                }
                            }));
                            result.getRequestChannel().resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)proxyConnection.getConnection());
                        exchangeListener.taskFailed();
                    }
                }

                @Override
                public void failed(IOException e) {
                    exchangeListener.taskFailed();
                }
            });
        }
    }

    static interface PingCallback {
        public void completed();

        public void failed();
    }
}

