/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaExpression {
    private List<String> formalParameters = new ArrayList<String>();
    private ValueExpression expression;
    private ELContext context;
    private Map<String, Object> envirArgs;

    public LambdaExpression(List<String> formalParameters, ValueExpression expression) {
        this.formalParameters = formalParameters;
        this.expression = expression;
        this.envirArgs = new HashMap<String, Object>();
    }

    public void setELContext(ELContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ELContext elContext, Object ... args2) throws ELException {
        int i = 0;
        HashMap<String, Object> lambdaArgs = new HashMap<String, Object>();
        lambdaArgs.putAll(this.envirArgs);
        for (String fParam : this.formalParameters) {
            if (i >= args2.length) {
                throw new ELException("Expected Argument " + fParam + " missing in Lambda Expression");
            }
            lambdaArgs.put(fParam, args2[i++]);
        }
        elContext.enterLambdaScope(lambdaArgs);
        try {
            Object ret = this.expression.getValue(elContext);
            if (ret instanceof LambdaExpression) {
                ((LambdaExpression)ret).envirArgs.putAll(lambdaArgs);
            }
            Object object = ret;
            return object;
        }
        finally {
            elContext.exitLambdaScope();
        }
    }

    public Object invoke(Object ... args2) {
        return this.invoke(this.context, args2);
    }
}

