/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.parser;

import com.sun.el.lang.EvaluationContext;
import com.sun.el.parser.SimpleNode;
import jakarta.el.ELException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int id) {
        super(id);
    }

    @Override
    public Class getType(EvaluationContext ctx) throws ELException {
        return Number.class;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object obj = this.children[0].getValue(ctx);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).negate();
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).negate();
        }
        if (obj instanceof String) {
            if (AstNegative.isStringFloat((String)obj)) {
                return -Double.parseDouble((String)obj);
            }
            return -Long.parseLong((String)obj);
        }
        Class<?> type2 = obj.getClass();
        if (obj instanceof Long || Long.TYPE == type2) {
            return -((Long)obj).longValue();
        }
        if (obj instanceof Double || Double.TYPE == type2) {
            return -((Double)obj).doubleValue();
        }
        if (obj instanceof Integer || Integer.TYPE == type2) {
            return -((Integer)obj).intValue();
        }
        if (obj instanceof Float || Float.TYPE == type2) {
            return Float.valueOf(-((Float)obj).floatValue());
        }
        if (obj instanceof Short || Short.TYPE == type2) {
            return -((Short)obj).shortValue();
        }
        if (obj instanceof Byte || Byte.TYPE == type2) {
            return -((Byte)obj).byteValue();
        }
        Long num = (Long)AstNegative.coerceToNumber(obj, Long.class);
        return -num.longValue();
    }
}

