/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.RetryConfiguration;
import java.beans.ConstructorProperties;
import java.time.Instant;

public final class RetryStatus {
    private final RetryConfiguration retryConfiguration;
    private final Object task;
    private final Exception exception;
    private final int numberOfTimesRetried;
    private final Instant initialErrorTimestamp;

    public RetryStatus afterRetry(Exception exception) {
        return this.toBuilder().exception(exception).numberOfTimesRetried(this.numberOfTimesRetried + 1).build();
    }

    private static int $default$numberOfTimesRetried() {
        return 0;
    }

    private static Instant $default$initialErrorTimestamp() {
        return Instant.now();
    }

    @ConstructorProperties(value={"retryConfiguration", "task", "exception", "numberOfTimesRetried", "initialErrorTimestamp"})
    RetryStatus(RetryConfiguration retryConfiguration, Object task, Exception exception, int numberOfTimesRetried, Instant initialErrorTimestamp) {
        this.retryConfiguration = retryConfiguration;
        this.task = task;
        this.exception = exception;
        this.numberOfTimesRetried = numberOfTimesRetried;
        this.initialErrorTimestamp = initialErrorTimestamp;
    }

    public static RetryStatusBuilder builder() {
        return new RetryStatusBuilder();
    }

    public RetryStatusBuilder toBuilder() {
        return new RetryStatusBuilder().retryConfiguration(this.retryConfiguration).task(this.task).exception(this.exception).numberOfTimesRetried(this.numberOfTimesRetried).initialErrorTimestamp(this.initialErrorTimestamp);
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public Object getTask() {
        return this.task;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getNumberOfTimesRetried() {
        return this.numberOfTimesRetried;
    }

    public Instant getInitialErrorTimestamp() {
        return this.initialErrorTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryStatus)) {
            return false;
        }
        RetryStatus other = (RetryStatus)o;
        if (this.getNumberOfTimesRetried() != other.getNumberOfTimesRetried()) {
            return false;
        }
        RetryConfiguration this$retryConfiguration = this.getRetryConfiguration();
        RetryConfiguration other$retryConfiguration = other.getRetryConfiguration();
        if (this$retryConfiguration == null ? other$retryConfiguration != null : !((Object)this$retryConfiguration).equals(other$retryConfiguration)) {
            return false;
        }
        Object this$task = this.getTask();
        Object other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        Instant this$initialErrorTimestamp = this.getInitialErrorTimestamp();
        Instant other$initialErrorTimestamp = other.getInitialErrorTimestamp();
        return !(this$initialErrorTimestamp == null ? other$initialErrorTimestamp != null : !((Object)this$initialErrorTimestamp).equals(other$initialErrorTimestamp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberOfTimesRetried();
        RetryConfiguration $retryConfiguration = this.getRetryConfiguration();
        result = result * 59 + ($retryConfiguration == null ? 43 : ((Object)$retryConfiguration).hashCode());
        Object $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        Instant $initialErrorTimestamp = this.getInitialErrorTimestamp();
        result = result * 59 + ($initialErrorTimestamp == null ? 43 : ((Object)$initialErrorTimestamp).hashCode());
        return result;
    }

    public String toString() {
        return "RetryStatus(retryConfiguration=" + String.valueOf(this.getRetryConfiguration()) + ", task=" + String.valueOf(this.getTask()) + ", exception=" + String.valueOf(this.getException()) + ", numberOfTimesRetried=" + this.getNumberOfTimesRetried() + ", initialErrorTimestamp=" + String.valueOf(this.getInitialErrorTimestamp()) + ")";
    }

    public static class RetryStatusBuilder {
        private RetryConfiguration retryConfiguration;
        private Object task;
        private Exception exception;
        private boolean numberOfTimesRetried$set;
        private int numberOfTimesRetried$value;
        private boolean initialErrorTimestamp$set;
        private Instant initialErrorTimestamp$value;

        RetryStatusBuilder() {
        }

        public RetryStatusBuilder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public RetryStatusBuilder task(Object task) {
            this.task = task;
            return this;
        }

        public RetryStatusBuilder exception(Exception exception) {
            this.exception = exception;
            return this;
        }

        public RetryStatusBuilder numberOfTimesRetried(int numberOfTimesRetried) {
            this.numberOfTimesRetried$value = numberOfTimesRetried;
            this.numberOfTimesRetried$set = true;
            return this;
        }

        public RetryStatusBuilder initialErrorTimestamp(Instant initialErrorTimestamp) {
            this.initialErrorTimestamp$value = initialErrorTimestamp;
            this.initialErrorTimestamp$set = true;
            return this;
        }

        public RetryStatus build() {
            int numberOfTimesRetried$value = this.numberOfTimesRetried$value;
            if (!this.numberOfTimesRetried$set) {
                numberOfTimesRetried$value = RetryStatus.$default$numberOfTimesRetried();
            }
            Instant initialErrorTimestamp$value = this.initialErrorTimestamp$value;
            if (!this.initialErrorTimestamp$set) {
                initialErrorTimestamp$value = RetryStatus.$default$initialErrorTimestamp();
            }
            return new RetryStatus(this.retryConfiguration, this.task, this.exception, numberOfTimesRetried$value, initialErrorTimestamp$value);
        }

        public String toString() {
            return "RetryStatus.RetryStatusBuilder(retryConfiguration=" + String.valueOf(this.retryConfiguration) + ", task=" + String.valueOf(this.task) + ", exception=" + String.valueOf(this.exception) + ", numberOfTimesRetried$value=" + this.numberOfTimesRetried$value + ", initialErrorTimestamp$value=" + String.valueOf(this.initialErrorTimestamp$value) + ")";
        }
    }
}

