/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.eventsourcing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.util.List;

public final class EventBatch {
    private final String aggregateId;
    private final List<SerializedMessage> events;
    private final boolean storeOnly;

    @JsonIgnore
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @JsonIgnore
    public int getSize() {
        return this.events.size();
    }

    public String toString() {
        return "EventBatch{aggregateId='" + this.aggregateId + "', event count=" + this.events.size() + ", storeOnly=" + this.storeOnly + "}";
    }

    @JsonIgnore
    public Metric toMetric() {
        return Metric.builder().aggregateId(this.aggregateId).size(this.events.size()).storeOnly(this.storeOnly).build();
    }

    @ConstructorProperties(value={"aggregateId", "events", "storeOnly"})
    public EventBatch(String aggregateId, List<SerializedMessage> events, boolean storeOnly) {
        this.aggregateId = aggregateId;
        this.events = events;
        this.storeOnly = storeOnly;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public List<SerializedMessage> getEvents() {
        return this.events;
    }

    public boolean isStoreOnly() {
        return this.storeOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventBatch)) {
            return false;
        }
        EventBatch other = (EventBatch)o;
        if (this.isStoreOnly() != other.isStoreOnly()) {
            return false;
        }
        String this$aggregateId = this.getAggregateId();
        String other$aggregateId = other.getAggregateId();
        if (this$aggregateId == null ? other$aggregateId != null : !this$aggregateId.equals(other$aggregateId)) {
            return false;
        }
        List<SerializedMessage> this$events = this.getEvents();
        List<SerializedMessage> other$events = other.getEvents();
        return !(this$events == null ? other$events != null : !((Object)this$events).equals(other$events));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStoreOnly() ? 79 : 97);
        String $aggregateId = this.getAggregateId();
        result = result * 59 + ($aggregateId == null ? 43 : $aggregateId.hashCode());
        List<SerializedMessage> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        return result;
    }

    public static final class Metric {
        private final String aggregateId;
        private final int size;
        private final boolean storeOnly;

        @ConstructorProperties(value={"aggregateId", "size", "storeOnly"})
        Metric(String aggregateId, int size, boolean storeOnly) {
            this.aggregateId = aggregateId;
            this.size = size;
            this.storeOnly = storeOnly;
        }

        public static MetricBuilder builder() {
            return new MetricBuilder();
        }

        public String getAggregateId() {
            return this.aggregateId;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isStoreOnly() {
            return this.storeOnly;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.isStoreOnly() != other.isStoreOnly()) {
                return false;
            }
            String this$aggregateId = this.getAggregateId();
            String other$aggregateId = other.getAggregateId();
            return !(this$aggregateId == null ? other$aggregateId != null : !this$aggregateId.equals(other$aggregateId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            result = result * 59 + (this.isStoreOnly() ? 79 : 97);
            String $aggregateId = this.getAggregateId();
            result = result * 59 + ($aggregateId == null ? 43 : $aggregateId.hashCode());
            return result;
        }

        public String toString() {
            return "EventBatch.Metric(aggregateId=" + this.getAggregateId() + ", size=" + this.getSize() + ", storeOnly=" + this.isStoreOnly() + ")";
        }

        public static class MetricBuilder {
            private String aggregateId;
            private int size;
            private boolean storeOnly;

            MetricBuilder() {
            }

            public MetricBuilder aggregateId(String aggregateId) {
                this.aggregateId = aggregateId;
                return this;
            }

            public MetricBuilder size(int size) {
                this.size = size;
                return this;
            }

            public MetricBuilder storeOnly(boolean storeOnly) {
                this.storeOnly = storeOnly;
                return this;
            }

            public Metric build() {
                return new Metric(this.aggregateId, this.size, this.storeOnly);
            }

            public String toString() {
                return "EventBatch.Metric.MetricBuilder(aggregateId=" + this.aggregateId + ", size=" + this.size + ", storeOnly=" + this.storeOnly + ")";
            }
        }
    }
}

