/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.modeling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.modeling.Relationship;
import java.beans.ConstructorProperties;
import java.util.Set;
import java.util.stream.Stream;

public final class UpdateRelationships
extends Command {
    private final Set<Relationship> associations;
    private final Set<Relationship> dissociations;
    private final Guarantee guarantee;

    @Override
    public String routingKey() {
        return Stream.concat(this.associations.stream(), this.dissociations.stream()).map(Relationship::getAggregateId).findFirst().orElse(null);
    }

    @ConstructorProperties(value={"associations", "dissociations", "guarantee"})
    public UpdateRelationships(Set<Relationship> associations, Set<Relationship> dissociations, Guarantee guarantee) {
        this.associations = associations;
        this.dissociations = dissociations;
        this.guarantee = guarantee;
    }

    public Set<Relationship> getAssociations() {
        return this.associations;
    }

    public Set<Relationship> getDissociations() {
        return this.dissociations;
    }

    @Override
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateRelationships)) {
            return false;
        }
        UpdateRelationships other = (UpdateRelationships)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Relationship> this$associations = this.getAssociations();
        Set<Relationship> other$associations = other.getAssociations();
        if (this$associations == null ? other$associations != null : !((Object)this$associations).equals(other$associations)) {
            return false;
        }
        Set<Relationship> this$dissociations = this.getDissociations();
        Set<Relationship> other$dissociations = other.getDissociations();
        if (this$dissociations == null ? other$dissociations != null : !((Object)this$dissociations).equals(other$dissociations)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpdateRelationships;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Relationship> $associations = this.getAssociations();
        result = result * 59 + ($associations == null ? 43 : ((Object)$associations).hashCode());
        Set<Relationship> $dissociations = this.getDissociations();
        result = result * 59 + ($dissociations == null ? 43 : ((Object)$dissociations).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateRelationships(associations=" + String.valueOf(this.getAssociations()) + ", dissociations=" + String.valueOf(this.getDissociations()) + ", guarantee=" + String.valueOf((Object)this.getGuarantee()) + ")";
    }
}

