/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import java.beans.ConstructorProperties;
import java.util.List;

public final class SearchDocumentsResult
implements QueryResult {
    private final long requestId;
    private final List<SerializedDocument> matches;
    private final long timestamp = System.currentTimeMillis();

    @Override
    public Metric toMetric() {
        return new Metric(this.matches.size(), this.timestamp);
    }

    public int size() {
        return this.matches.size();
    }

    public SerializedDocument lastMatch() {
        return this.matches.isEmpty() ? null : this.matches.get(this.matches.size() - 1);
    }

    @ConstructorProperties(value={"requestId", "matches"})
    public SearchDocumentsResult(long requestId, List<SerializedDocument> matches) {
        this.requestId = requestId;
        this.matches = matches;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    public List<SerializedDocument> getMatches() {
        return this.matches;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchDocumentsResult)) {
            return false;
        }
        SearchDocumentsResult other = (SearchDocumentsResult)o;
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        List<SerializedDocument> this$matches = this.getMatches();
        List<SerializedDocument> other$matches = other.getMatches();
        return !(this$matches == null ? other$matches != null : !((Object)this$matches).equals(other$matches));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        List<SerializedDocument> $matches = this.getMatches();
        result = result * 59 + ($matches == null ? 43 : ((Object)$matches).hashCode());
        return result;
    }

    public String toString() {
        return "SearchDocumentsResult(requestId=" + this.getRequestId() + ", matches=" + String.valueOf(this.getMatches()) + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static final class Metric {
        private final int size;
        private final long timestamp;

        @ConstructorProperties(value={"size", "timestamp"})
        public Metric(int size, long timestamp) {
            this.size = size;
            this.timestamp = timestamp;
        }

        public int getSize() {
            return this.size;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result;
        }

        public String toString() {
            return "SearchDocumentsResult.Metric(size=" + this.getSize() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }
}

