/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search.constraints;

import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.NoOpConstraint;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public final class AnyConstraint
implements Constraint {
    private final List<Constraint> any;
    private final AtomicReference<Object> decompose = new AtomicReference();

    public static Constraint any(Constraint ... constraints) {
        return AnyConstraint.any(Arrays.asList(constraints));
    }

    public static Constraint any(Collection<Constraint> constraints) {
        List<Constraint> list = constraints.stream().distinct().collect(Collectors.toList());
        return switch (list.size()) {
            case 0 -> NoOpConstraint.instance;
            case 1 -> (Constraint)list.get(0);
            default -> new AnyConstraint(list);
        };
    }

    @Override
    public boolean matches(Document document) {
        return this.any.stream().anyMatch(c -> c.matches(document));
    }

    @Override
    public boolean hasPathConstraint() {
        return this.any.stream().anyMatch(Constraint::hasPathConstraint);
    }

    public List<Constraint> getAny() {
        return this.any;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnyConstraint)) {
            return false;
        }
        AnyConstraint other = (AnyConstraint)o;
        List<Constraint> this$any = this.getAny();
        List<Constraint> other$any = other.getAny();
        return !(this$any == null ? other$any != null : !((Object)this$any).equals(other$any));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Constraint> $any = this.getAny();
        result = result * 59 + ($any == null ? 43 : ((Object)$any).hashCode());
        return result;
    }

    public String toString() {
        return "AnyConstraint(any=" + String.valueOf(this.getAny()) + ")";
    }

    @ConstructorProperties(value={"any"})
    private AnyConstraint(List<Constraint> any) {
        this.any = any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constraint decompose() {
        Object value = this.decompose.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.decompose;
            synchronized (atomicReference) {
                value = this.decompose.get();
                if (value == null) {
                    AnyConstraint actualValue = new AnyConstraint(this.getAny().stream().map(Constraint::decompose).collect(Collectors.toList()));
                    value = actualValue == null ? this.decompose : actualValue;
                    this.decompose.set(value);
                }
            }
        }
        return (Constraint)(value == this.decompose ? null : value);
    }
}

