/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search.constraints;

import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.NoOpConstraint;
import io.fluxcapacitor.common.api.search.constraints.ContainsConstraint;
import io.fluxcapacitor.common.api.search.constraints.PathConstraint;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class LookAheadConstraint
extends PathConstraint {
    @NonNull
    private final String lookAhead;
    private final List<String> paths;
    private final AtomicReference<Object> decompose = new AtomicReference();

    public static Constraint lookAhead(String lookAhead, String ... paths) {
        return StringUtils.isBlank(lookAhead) ? NoOpConstraint.instance : new LookAheadConstraint(lookAhead, List.of(paths));
    }

    @Override
    public boolean matches(Document document) {
        return this.decompose().matches(document);
    }

    @Override
    protected boolean matches(Document.Entry entry) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public String getLookAhead() {
        return this.lookAhead;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookAheadConstraint)) {
            return false;
        }
        LookAheadConstraint other = (LookAheadConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$lookAhead = this.getLookAhead();
        String other$lookAhead = other.getLookAhead();
        if (this$lookAhead == null ? other$lookAhead != null : !this$lookAhead.equals(other$lookAhead)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LookAheadConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $lookAhead = this.getLookAhead();
        result = result * 59 + ($lookAhead == null ? 43 : $lookAhead.hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    public String toString() {
        return "LookAheadConstraint(lookAhead=" + this.getLookAhead() + ", paths=" + String.valueOf(this.getPaths()) + ")";
    }

    @ConstructorProperties(value={"lookAhead", "paths"})
    private LookAheadConstraint(@NonNull String lookAhead, List<String> paths) {
        if (lookAhead == null) {
            throw new NullPointerException("lookAhead is marked non-null but is null");
        }
        this.lookAhead = lookAhead;
        this.paths = paths;
    }

    @Override
    public LookAheadConstraint withPaths(List<String> paths) {
        return this.paths == paths ? this : new LookAheadConstraint(this.lookAhead, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constraint decompose() {
        Object value = this.decompose.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.decompose;
            synchronized (atomicReference) {
                value = this.decompose.get();
                if (value == null) {
                    Constraint actualValue = ContainsConstraint.contains(this.getLookAhead(), false, true, true, (String[])this.getPaths().toArray(String[]::new));
                    value = actualValue == null ? this.decompose : actualValue;
                    this.decompose.set(value);
                }
            }
        }
        return (Constraint)(value == this.decompose ? null : value);
    }
}

