/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.tracking;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.fluxcapacitor.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;

@JsonSerialize(using=PositionSerializer.class)
@JsonDeserialize(using=PositionDeserializer.class)
public final class Position {
    private static final Position newPosition = new Position(new TreeMap<Integer, Long>());
    public static int MAX_SEGMENT = 128;
    public static int[] FULL_SEGMENT = new int[]{0, MAX_SEGMENT};
    private final SortedMap<Integer, Long> indexBySegment;

    public static Position newPosition() {
        return newPosition;
    }

    public Position(long index) {
        this(new int[]{0, MAX_SEGMENT}, index);
    }

    public Position(int[] segment, long index) {
        TreeMap<Integer, Long> indexBySegment = new TreeMap<Integer, Long>();
        IntStream.range(segment[0], segment[1]).forEach(i -> indexBySegment.put(i, index));
        this.indexBySegment = indexBySegment;
    }

    public Optional<Long> getIndex(int segment) {
        return Optional.ofNullable((Long)this.indexBySegment.get(segment));
    }

    public boolean isNew(int[] segment) {
        return this.indexBySegment.entrySet().stream().filter(entry -> entry.getValue() != null).noneMatch(entry -> (Integer)entry.getKey() >= segment[0] && (Integer)entry.getKey() < segment[1]);
    }

    public Optional<Long> lowestIndexForSegment(int[] segment) {
        int start = segment[0];
        int end = segment[1];
        return this.indexBySegment.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> (Integer)entry.getKey() >= start && (Integer)entry.getKey() < end).map(Map.Entry::getValue).sorted().findFirst();
    }

    public Position merge(Position newPosition) {
        TreeMap<Integer, Long> indexBySegment = new TreeMap<Integer, Long>(this.indexBySegment);
        newPosition.indexBySegment.forEach((s, i) -> indexBySegment.merge((Integer)s, (Long)i, (v, v2) -> v2.compareTo((Long)v) > 0 ? v2 : v));
        return new Position(indexBySegment);
    }

    public Map<int[], Long> splitInSegments() {
        LinkedHashMap<int[], Long> result = new LinkedHashMap<int[], Long>();
        this.indexBySegment.entrySet().stream().map(e -> Map.entry(new int[]{(Integer)e.getKey(), (Integer)e.getKey() + 1}, (Long)e.getValue())).reduce((a, b) -> {
            if (Objects.equals(a.getValue(), b.getValue()) && ((int[])a.getKey())[1] == ((int[])b.getKey())[0]) {
                return Map.entry(new int[]{((int[])a.getKey())[0], ((int[])b.getKey())[1]}, (Long)b.getValue());
            }
            result.put((int[])a.getKey(), (Long)a.getValue());
            return b;
        }).ifPresent(e -> result.put((int[])e.getKey(), (Long)e.getValue()));
        return result;
    }

    public boolean isNewMessage(SerializedMessage message) {
        return this.isNewIndex(message.getSegment(), message.getIndex());
    }

    public boolean isNewIndex(int segment, Long messageIndex) {
        Long lastIndex = (Long)this.indexBySegment.get(segment);
        return lastIndex == null || messageIndex == null || lastIndex < messageIndex;
    }

    public SortedMap<Integer, Long> getIndexBySegment() {
        return this.indexBySegment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        SortedMap<Integer, Long> this$indexBySegment = this.getIndexBySegment();
        SortedMap<Integer, Long> other$indexBySegment = other.getIndexBySegment();
        return !(this$indexBySegment == null ? other$indexBySegment != null : !this$indexBySegment.equals(other$indexBySegment));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SortedMap<Integer, Long> $indexBySegment = this.getIndexBySegment();
        result = result * 59 + ($indexBySegment == null ? 43 : $indexBySegment.hashCode());
        return result;
    }

    public String toString() {
        return "Position(indexBySegment=" + String.valueOf(this.getIndexBySegment()) + ")";
    }

    @ConstructorProperties(value={"indexBySegment"})
    public Position(SortedMap<Integer, Long> indexBySegment) {
        this.indexBySegment = indexBySegment;
    }

    static class PositionDeserializer
    extends JsonDeserializer<Position> {
        private final TypeReference<SortedMap<Integer, Long>> mapTypeReference = new TypeReference<SortedMap<Integer, Long>>(this){};

        PositionDeserializer() {
        }

        @Override
        public Position deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return switch (p.getCurrentToken()) {
                case JsonToken.START_OBJECT -> {
                    p.nextToken();
                    p.nextToken();
                    yield new Position((SortedMap)p.readValueAs(this.mapTypeReference));
                }
                case JsonToken.START_ARRAY -> {
                    Position position = Position.newPosition();
                    while (p.nextToken() == JsonToken.START_ARRAY) {
                        int[] range = new int[2];
                        p.nextToken();
                        range[0] = p.getIntValue();
                        p.nextToken();
                        range[1] = p.getIntValue();
                        p.nextToken();
                        p.nextToken();
                        long index = p.getLongValue();
                        position = position.merge(new Position(range, index));
                    }
                    yield position;
                }
                default -> throw new UnsupportedOperationException();
            };
        }
    }

    static class PositionSerializer
    extends JsonSerializer<Position> {
        PositionSerializer() {
        }

        @Override
        public void serialize(Position value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartArray();
            for (Map.Entry<int[], Long> entry : value.splitInSegments().entrySet()) {
                gen.writeStartArray();
                gen.writeNumber(entry.getKey()[0]);
                gen.writeNumber(entry.getKey()[1]);
                gen.writeEndArray();
                gen.writeNumber(entry.getValue());
            }
            gen.writeEndArray();
        }
    }
}

