/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.application;

import io.fluxcapacitor.common.application.ApplicationEnvironmentPropertiesSource;
import io.fluxcapacitor.common.application.ApplicationPropertiesSource;
import io.fluxcapacitor.common.application.EnvironmentVariablesSource;
import io.fluxcapacitor.common.application.PropertySource;
import io.fluxcapacitor.common.application.SystemPropertiesSource;
import io.fluxcapacitor.common.encryption.DefaultEncryption;
import io.fluxcapacitor.common.encryption.Encryption;
import io.fluxcapacitor.common.encryption.NoOpEncryption;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertySource
implements PropertySource {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropertySource.class);
    private static final DefaultPropertySource instance = new DefaultPropertySource();
    private final Encryption encryption;
    private final PropertySource delegate;

    public DefaultPropertySource() {
        this(Optional.ofNullable(System.getenv("ENCRYPTION_KEY")).or(() -> Optional.ofNullable(System.getenv("encryption_key"))).or(() -> Optional.ofNullable(System.getProperty("ENCRYPTION_KEY"))).or(() -> Optional.ofNullable(System.getProperty("encryption_key"))).map(encodedKey -> {
            try {
                return DefaultEncryption.fromEncryptionKey(encodedKey);
            }
            catch (Exception e) {
                log.error("Could not construct DefaultEncryption from environment variable `ENCRYPTION_KEY`");
                return NoOpEncryption.INSTANCE;
            }
        }).orElse(NoOpEncryption.INSTANCE));
    }

    public DefaultPropertySource(String encryptionKey) {
        this(DefaultEncryption.fromEncryptionKey(encryptionKey));
    }

    public DefaultPropertySource(Encryption encryption) {
        this.encryption = encryption;
        this.delegate = PropertySource.join(EnvironmentVariablesSource.INSTANCE, new SystemPropertiesSource(encryption), new ApplicationEnvironmentPropertiesSource(encryption), new ApplicationPropertiesSource(encryption));
    }

    @Override
    public String get(String name) {
        return this.delegate.get(name);
    }

    public static DefaultPropertySource getInstance() {
        return instance;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }
}

