/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.encryption;

import io.fluxcapacitor.common.encryption.ChaCha20Poly1305Encryption;
import io.fluxcapacitor.common.encryption.Encryption;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEncryption
implements Encryption {
    private static final Logger log = LoggerFactory.getLogger(DefaultEncryption.class);
    private final Encryption delegate;

    public static String generateNewEncryptionKey() {
        return new DefaultEncryption().getEncryptionKey();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Encryption fromEncryptionKey(@NonNull String encryptionKey) {
        if (encryptionKey == null) {
            throw new NullPointerException("encryptionKey is marked non-null but is null");
        }
        String[] algorithmAndKey = encryptionKey.split("\\|", 2);
        if (algorithmAndKey.length != 2) {
            throw new IllegalArgumentException("Encryption key is missing algorithm");
        }
        switch (algorithmAndKey[0]) {
            case "ChaCha20": {
                return new DefaultEncryption(new ChaCha20Poly1305Encryption(algorithmAndKey[1]));
            }
            default: {
                throw new IllegalArgumentException("Unknown encryption algorithm: " + algorithmAndKey[0]);
            }
        }
    }

    public DefaultEncryption() {
        this(new ChaCha20Poly1305Encryption());
    }

    @Override
    public String encrypt(String value) {
        return String.format("%s|%s", this.getAlgorithm(), this.delegate.encrypt(value));
    }

    @Override
    public String decrypt(String value) {
        if (value != null && value.startsWith(this.getAlgorithm() + "|")) {
            return this.delegate.decrypt(value.split(this.getAlgorithm() + "\\|")[1]);
        }
        return value;
    }

    @Override
    public String getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    @Override
    public String getEncryptionKey() {
        return this.getAlgorithm() + "|" + this.delegate.getEncryptionKey();
    }

    @ConstructorProperties(value={"delegate"})
    public DefaultEncryption(Encryption delegate) {
        this.delegate = delegate;
    }
}

