/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public final class HandlerConfiguration<M> {
    private final Class<? extends Annotation> methodAnnotation;
    private final boolean invokeMultipleMethods;
    private final HandlerFilter handlerFilter;
    private final MessageFilter<? super M> messageFilter;

    public boolean methodMatches(Class<?> c, Executable e) {
        return this.isEnabled(e) && this.handlerFilter.test(c, e);
    }

    boolean isEnabled(Executable e) {
        if (this.methodAnnotation == null) {
            return true;
        }
        Annotation annotation = this.getAnnotation(e).orElse(null);
        if (annotation == null) {
            return false;
        }
        Optional<Method> match = Arrays.stream(annotation.annotationType().getMethods()).filter(m -> m.getName().equals("disabled")).findFirst();
        if (match.isPresent()) {
            boolean result = (Boolean)match.get().invoke((Object)annotation, new Object[0]);
            return !result;
        }
        return true;
    }

    public Optional<? extends Annotation> getAnnotation(Executable e) {
        return Optional.ofNullable(this.methodAnnotation).flatMap(a -> ReflectionUtils.getMethodAnnotation(e, this.methodAnnotation));
    }

    private static <M> boolean $default$invokeMultipleMethods() {
        return false;
    }

    private static <M> HandlerFilter $default$handlerFilter() {
        return (c, e) -> true;
    }

    private static <M> MessageFilter<? super M> $default$messageFilter() {
        return (m, e) -> true;
    }

    @ConstructorProperties(value={"methodAnnotation", "invokeMultipleMethods", "handlerFilter", "messageFilter"})
    HandlerConfiguration(Class<? extends Annotation> methodAnnotation, boolean invokeMultipleMethods, HandlerFilter handlerFilter, MessageFilter<? super M> messageFilter) {
        this.methodAnnotation = methodAnnotation;
        this.invokeMultipleMethods = invokeMultipleMethods;
        this.handlerFilter = handlerFilter;
        this.messageFilter = messageFilter;
    }

    public static <M> HandlerConfigurationBuilder<M> builder() {
        return new HandlerConfigurationBuilder();
    }

    public HandlerConfigurationBuilder<M> toBuilder() {
        return new HandlerConfigurationBuilder().methodAnnotation(this.methodAnnotation).invokeMultipleMethods(this.invokeMultipleMethods).handlerFilter(this.handlerFilter).messageFilter(this.messageFilter);
    }

    public Class<? extends Annotation> methodAnnotation() {
        return this.methodAnnotation;
    }

    public boolean invokeMultipleMethods() {
        return this.invokeMultipleMethods;
    }

    public HandlerFilter handlerFilter() {
        return this.handlerFilter;
    }

    public MessageFilter<? super M> messageFilter() {
        return this.messageFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandlerConfiguration)) {
            return false;
        }
        HandlerConfiguration other = (HandlerConfiguration)o;
        if (this.invokeMultipleMethods() != other.invokeMultipleMethods()) {
            return false;
        }
        Class<Annotation> this$methodAnnotation = this.methodAnnotation();
        Class<Annotation> other$methodAnnotation = other.methodAnnotation();
        if (this$methodAnnotation == null ? other$methodAnnotation != null : !this$methodAnnotation.equals(other$methodAnnotation)) {
            return false;
        }
        HandlerFilter this$handlerFilter = this.handlerFilter();
        HandlerFilter other$handlerFilter = other.handlerFilter();
        if (this$handlerFilter == null ? other$handlerFilter != null : !this$handlerFilter.equals(other$handlerFilter)) {
            return false;
        }
        MessageFilter<M> this$messageFilter = this.messageFilter();
        MessageFilter<M> other$messageFilter = other.messageFilter();
        return !(this$messageFilter == null ? other$messageFilter != null : !this$messageFilter.equals(other$messageFilter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.invokeMultipleMethods() ? 79 : 97);
        Class<Annotation> $methodAnnotation = this.methodAnnotation();
        result = result * 59 + ($methodAnnotation == null ? 43 : $methodAnnotation.hashCode());
        HandlerFilter $handlerFilter = this.handlerFilter();
        result = result * 59 + ($handlerFilter == null ? 43 : $handlerFilter.hashCode());
        MessageFilter<M> $messageFilter = this.messageFilter();
        result = result * 59 + ($messageFilter == null ? 43 : $messageFilter.hashCode());
        return result;
    }

    public String toString() {
        return "HandlerConfiguration(methodAnnotation=" + String.valueOf(this.methodAnnotation()) + ", invokeMultipleMethods=" + this.invokeMultipleMethods() + ", handlerFilter=" + String.valueOf(this.handlerFilter()) + ", messageFilter=" + String.valueOf(this.messageFilter()) + ")";
    }

    public static class HandlerConfigurationBuilder<M> {
        private Class<? extends Annotation> methodAnnotation;
        private boolean invokeMultipleMethods$set;
        private boolean invokeMultipleMethods$value;
        private boolean handlerFilter$set;
        private HandlerFilter handlerFilter$value;
        private boolean messageFilter$set;
        private MessageFilter<? super M> messageFilter$value;

        HandlerConfigurationBuilder() {
        }

        public HandlerConfigurationBuilder<M> methodAnnotation(Class<? extends Annotation> methodAnnotation) {
            this.methodAnnotation = methodAnnotation;
            return this;
        }

        public HandlerConfigurationBuilder<M> invokeMultipleMethods(boolean invokeMultipleMethods) {
            this.invokeMultipleMethods$value = invokeMultipleMethods;
            this.invokeMultipleMethods$set = true;
            return this;
        }

        public HandlerConfigurationBuilder<M> handlerFilter(HandlerFilter handlerFilter) {
            this.handlerFilter$value = handlerFilter;
            this.handlerFilter$set = true;
            return this;
        }

        public HandlerConfigurationBuilder<M> messageFilter(MessageFilter<? super M> messageFilter) {
            this.messageFilter$value = messageFilter;
            this.messageFilter$set = true;
            return this;
        }

        public HandlerConfiguration<M> build() {
            boolean invokeMultipleMethods$value = this.invokeMultipleMethods$value;
            if (!this.invokeMultipleMethods$set) {
                invokeMultipleMethods$value = HandlerConfiguration.$default$invokeMultipleMethods();
            }
            HandlerFilter handlerFilter$value = this.handlerFilter$value;
            if (!this.handlerFilter$set) {
                handlerFilter$value = HandlerConfiguration.$default$handlerFilter();
            }
            MessageFilter<Object> messageFilter$value = this.messageFilter$value;
            if (!this.messageFilter$set) {
                messageFilter$value = HandlerConfiguration.$default$messageFilter();
            }
            return new HandlerConfiguration<M>(this.methodAnnotation, invokeMultipleMethods$value, handlerFilter$value, messageFilter$value);
        }

        public String toString() {
            return "HandlerConfiguration.HandlerConfigurationBuilder(methodAnnotation=" + String.valueOf(this.methodAnnotation) + ", invokeMultipleMethods$value=" + this.invokeMultipleMethods$value + ", handlerFilter$value=" + String.valueOf(this.handlerFilter$value) + ", messageFilter$value=" + String.valueOf(this.messageFilter$value) + ")";
        }
    }
}

