/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;

public interface HandlerInvoker {
    public Class<?> getTargetClass();

    public Executable getMethod();

    public <A extends Annotation> A getMethodAnnotation();

    public boolean expectResult();

    public boolean isPassive();

    default public Object invoke() {
        return this.invoke((first, second) -> {
            ArrayList<Object> combination;
            ArrayList<Object> arrayList = first instanceof ArrayList ? (ArrayList<Object>)first : (combination = first instanceof Collection ? new ArrayList((Collection)first) : new ArrayList<Object>(Collections.singletonList(first)));
            if (second instanceof Collection) {
                combination.addAll((Collection)second);
            } else {
                combination.add(second);
            }
            return combination;
        });
    }

    public Object invoke(BiFunction<Object, Object, Object> var1);

    default public HandlerInvoker combine(final HandlerInvoker second) {
        return new DelegatingHandlerInvoker(this, this){

            @Override
            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                return combiner.apply(this.delegate.invoke(), second.invoke());
            }
        };
    }

    public static abstract class DelegatingHandlerInvoker
    implements HandlerInvoker {
        protected final HandlerInvoker delegate;

        @Override
        public Class<?> getTargetClass() {
            return this.delegate.getTargetClass();
        }

        @Override
        public Executable getMethod() {
            return this.delegate.getMethod();
        }

        @Override
        public <A extends Annotation> A getMethodAnnotation() {
            return this.delegate.getMethodAnnotation();
        }

        @Override
        public boolean expectResult() {
            return this.delegate.expectResult();
        }

        @Override
        public boolean isPassive() {
            return this.delegate.isPassive();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate"})
        public DelegatingHandlerInvoker(HandlerInvoker delegate) {
            this.delegate = delegate;
        }
    }
}

