/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.common.tracking.Tracker;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class WebSocketTracker
implements Tracker {
    private final String consumerName;
    private final MessageType messageType;
    private final String clientId;
    private final String sessionId;
    private final String trackerId;
    private final Long lastTrackerIndex;
    private final long deadline;
    private final Long purgeDelay;
    private final int maxSize;
    private final Predicate<String> typeFilter;
    private final boolean filterMessageTarget;
    private final boolean ignoreSegment;
    private final boolean clientControlledIndex;
    private final boolean singleTracker;
    private final long maxTimeout;
    private final Consumer<MessageBatch> handler;

    public WebSocketTracker(Read read, MessageType messageType, String clientId, String sessionId, Consumer<MessageBatch> handler) {
        this.consumerName = read.getConsumer();
        this.messageType = messageType;
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.trackerId = read.getTrackerId();
        this.lastTrackerIndex = read.getLastIndex();
        this.maxTimeout = read.getMaxTimeout();
        this.deadline = System.currentTimeMillis() + read.getMaxTimeout();
        this.purgeDelay = read.getPurgeTimeout();
        this.maxSize = read.getMaxSize();
        this.typeFilter = WebSocketTracker.toPredicate(read.getTypeFilter());
        this.filterMessageTarget = read.isFilterMessageTarget();
        this.ignoreSegment = read.isIgnoreSegment() || messageType == MessageType.NOTIFICATION;
        this.clientControlledIndex = read.isClientControlledIndex() || messageType == MessageType.NOTIFICATION;
        this.singleTracker = read.isSingleTracker();
        this.handler = handler;
    }

    private static Predicate<String> toPredicate(String typeFilter) {
        if (typeFilter == null) {
            return s -> true;
        }
        return Pattern.compile(typeFilter).asMatchPredicate();
    }

    @Override
    public void send(MessageBatch batch) {
        this.handler.accept(batch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketTracker that = (WebSocketTracker)o;
        return Objects.equals(this.consumerName, that.consumerName) && Objects.equals(this.trackerId, that.trackerId);
    }

    public int hashCode() {
        return Objects.hash(this.consumerName, this.trackerId);
    }

    public String toString() {
        return "WebSocketTracker{consumerName='" + this.consumerName + "', clientId='" + this.clientId + "', trackerId='" + this.trackerId + "'}";
    }

    @Override
    public String getConsumerName() {
        return this.consumerName;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getTrackerId() {
        return this.trackerId;
    }

    @Override
    public Long getLastTrackerIndex() {
        return this.lastTrackerIndex;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public Long getPurgeDelay() {
        return this.purgeDelay;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public Predicate<String> getTypeFilter() {
        return this.typeFilter;
    }

    @Override
    public boolean isFilterMessageTarget() {
        return this.filterMessageTarget;
    }

    @Override
    public boolean ignoreSegment() {
        return this.ignoreSegment;
    }

    @Override
    public boolean clientControlledIndex() {
        return this.clientControlledIndex;
    }

    @Override
    public boolean singleTracker() {
        return this.singleTracker;
    }

    @Override
    public long maxTimeout() {
        return this.maxTimeout;
    }

    public Consumer<MessageBatch> getHandler() {
        return this.handler;
    }

    @ConstructorProperties(value={"consumerName", "messageType", "clientId", "sessionId", "trackerId", "lastTrackerIndex", "deadline", "purgeDelay", "maxSize", "typeFilter", "filterMessageTarget", "ignoreSegment", "clientControlledIndex", "singleTracker", "maxTimeout", "handler"})
    public WebSocketTracker(String consumerName, MessageType messageType, String clientId, String sessionId, String trackerId, Long lastTrackerIndex, long deadline, Long purgeDelay, int maxSize, Predicate<String> typeFilter, boolean filterMessageTarget, boolean ignoreSegment, boolean clientControlledIndex, boolean singleTracker, long maxTimeout, Consumer<MessageBatch> handler) {
        this.consumerName = consumerName;
        this.messageType = messageType;
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.trackerId = trackerId;
        this.lastTrackerIndex = lastTrackerIndex;
        this.deadline = deadline;
        this.purgeDelay = purgeDelay;
        this.maxSize = maxSize;
        this.typeFilter = typeFilter;
        this.filterMessageTarget = filterMessageTarget;
        this.ignoreSegment = ignoreSegment;
        this.clientControlledIndex = clientControlledIndex;
        this.singleTracker = singleTracker;
        this.maxTimeout = maxTimeout;
        this.handler = handler;
    }

    @Override
    public WebSocketTracker withLastTrackerIndex(Long lastTrackerIndex) {
        return this.lastTrackerIndex == lastTrackerIndex ? this : new WebSocketTracker(this.consumerName, this.messageType, this.clientId, this.sessionId, this.trackerId, lastTrackerIndex, this.deadline, this.purgeDelay, this.maxSize, this.typeFilter, this.filterMessageTarget, this.ignoreSegment, this.clientControlledIndex, this.singleTracker, this.maxTimeout, this.handler);
    }
}

