/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.ThrowingConsumer;
import io.fluxcapacitor.common.ThrowingFunction;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.application.PropertySource;
import io.fluxcapacitor.common.caching.Cache;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.UuidFactory;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.Id;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.persisting.repository.AggregateRepository;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.Search;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.WebRequestGateway;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.correlation.DefaultCorrelationDataProvider;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.handling.Request;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;

public interface FluxCapacitor
extends AutoCloseable {
    public static final AtomicReference<FluxCapacitor> applicationInstance = new AtomicReference();
    public static final ThreadLocal<FluxCapacitor> instance = new ThreadLocal();

    public static FluxCapacitor get() {
        return Optional.ofNullable(instance.get()).orElseGet(() -> Optional.ofNullable(applicationInstance.get()).orElseThrow(() -> new IllegalStateException("FluxCapacitor instance not set")));
    }

    public static Optional<FluxCapacitor> getOptionally() {
        FluxCapacitor result = instance.get();
        return result == null ? Optional.ofNullable(applicationInstance.get()) : Optional.of(result);
    }

    public static Clock currentClock() {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::clock).orElseGet(Clock::systemUTC);
    }

    public static Instant currentTime() {
        return FluxCapacitor.currentClock().instant();
    }

    public static String generateId() {
        return FluxCapacitor.currentIdentityProvider().nextFunctionalId();
    }

    public static IdentityProvider currentIdentityProvider() {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::identityProvider).orElseGet(UuidFactory::new);
    }

    public static Map<String, String> currentCorrelationData() {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::correlationDataProvider).orElse(DefaultCorrelationDataProvider.INSTANCE).getCorrelationData();
    }

    public static void publishEvent(Object event) {
        FluxCapacitor.get().eventGateway().publish(event);
    }

    public static void publishEvent(Object payload, Metadata metadata2) {
        FluxCapacitor.get().eventGateway().publish(payload, metadata2);
    }

    public static void sendAndForgetCommand(Object command) {
        FluxCapacitor.get().commandGateway().sendAndForget(command);
    }

    public static void sendAndForgetCommands(Object ... commands) {
        FluxCapacitor.get().commandGateway().sendAndForget(commands);
    }

    public static void sendAndForgetCommand(Object payload, Metadata metadata2) {
        FluxCapacitor.get().commandGateway().sendAndForget(payload, metadata2);
    }

    public static void sendAndForgetCommand(Object payload, Metadata metadata2, Guarantee guarantee) {
        FluxCapacitor.get().commandGateway().sendAndForget(payload, metadata2, guarantee);
    }

    public static <R> CompletableFuture<R> sendCommand(Object command) {
        return FluxCapacitor.get().commandGateway().send(command);
    }

    public static <R> CompletableFuture<R> sendCommand(Request<R> command) {
        return FluxCapacitor.get().commandGateway().send(command);
    }

    public static <R> List<CompletableFuture<R>> sendCommands(Object ... commands) {
        return FluxCapacitor.get().commandGateway().send(commands);
    }

    public static <R> CompletableFuture<R> sendCommand(Object payload, Metadata metadata2) {
        return FluxCapacitor.get().commandGateway().send(payload, metadata2);
    }

    public static <R> CompletableFuture<R> sendCommand(Request<R> payload, Metadata metadata2) {
        return FluxCapacitor.get().commandGateway().send(payload, metadata2);
    }

    public static <R> R sendCommandAndWait(Object command) {
        return FluxCapacitor.get().commandGateway().sendAndWait(command);
    }

    public static <R> R sendCommandAndWait(Request<R> command) {
        return FluxCapacitor.get().commandGateway().sendAndWait(command);
    }

    public static <R> R sendCommandAndWait(Object payload, Metadata metadata2) {
        return FluxCapacitor.get().commandGateway().sendAndWait(payload, metadata2);
    }

    public static <R> R sendCommandAndWait(Request<R> payload, Metadata metadata2) {
        return FluxCapacitor.get().commandGateway().sendAndWait(payload, metadata2);
    }

    public static <R> CompletableFuture<R> query(Object query) {
        return FluxCapacitor.get().queryGateway().send(query);
    }

    public static <R> CompletableFuture<R> query(Request<R> query) {
        return FluxCapacitor.get().queryGateway().send(query);
    }

    public static <R> CompletableFuture<R> query(Object payload, Metadata metadata2) {
        return FluxCapacitor.get().queryGateway().send(payload, metadata2);
    }

    public static <R> CompletableFuture<R> query(Request<R> payload, Metadata metadata2) {
        return FluxCapacitor.get().queryGateway().send(payload, metadata2);
    }

    public static <R> R queryAndWait(Object query) {
        return FluxCapacitor.get().queryGateway().sendAndWait(query);
    }

    public static <R> R queryAndWait(Request<R> query) {
        return FluxCapacitor.get().queryGateway().sendAndWait(query);
    }

    public static <R> R queryAndWait(Object payload, Metadata metadata2) {
        return FluxCapacitor.get().queryGateway().sendAndWait(payload, metadata2);
    }

    public static <R> R queryAndWait(Request<R> payload, Metadata metadata2) {
        return FluxCapacitor.get().queryGateway().sendAndWait(payload, metadata2);
    }

    public static String schedule(Object schedule, Instant deadline) {
        return FluxCapacitor.get().scheduler().schedule(schedule, deadline);
    }

    public static void schedule(Object schedule, String scheduleId, Instant deadline) {
        FluxCapacitor.get().scheduler().schedule(schedule, scheduleId, deadline);
    }

    public static String schedule(Object schedule, Duration delay) {
        return FluxCapacitor.get().scheduler().schedule(schedule, delay);
    }

    public static void schedule(Object schedule, String scheduleId, Duration delay) {
        FluxCapacitor.get().scheduler().schedule(schedule, scheduleId, delay);
    }

    public static String scheduleCommand(Object command, Instant deadline) {
        return FluxCapacitor.get().scheduler().scheduleCommand(command, deadline);
    }

    public static void scheduleCommand(Object command, String scheduleId, Instant deadline) {
        FluxCapacitor.get().scheduler().scheduleCommand(command, scheduleId, deadline);
    }

    public static String scheduleCommand(Object command, Duration delay) {
        return FluxCapacitor.get().scheduler().scheduleCommand(command, delay);
    }

    public static void scheduleCommand(Object command, String scheduleId, Duration delay) {
        FluxCapacitor.get().scheduler().scheduleCommand(command, scheduleId, delay);
    }

    public static void cancelSchedule(String scheduleId) {
        FluxCapacitor.get().scheduler().cancelSchedule(scheduleId);
    }

    public static void publishMetrics(Object metrics) {
        FluxCapacitor.get().metricsGateway().publish(metrics);
    }

    public static void publishMetrics(Object payload, Metadata metadata2) {
        FluxCapacitor.get().metricsGateway().publish(payload, metadata2, Guarantee.NONE);
    }

    public static <T> Entity<T> loadAggregate(Id<T> aggregateId) {
        return FluxCapacitor.playbackToHandledEvent(FluxCapacitor.get().aggregateRepository().load(aggregateId));
    }

    public static <T> Entity<T> loadAggregate(Object aggregateId, Class<T> aggregateType) {
        return FluxCapacitor.playbackToHandledEvent(FluxCapacitor.get().aggregateRepository().load(aggregateId, aggregateType));
    }

    public static <T> Entity<T> loadAggregateFor(Object entityId, Class<?> defaultType2) {
        return FluxCapacitor.playbackToHandledEvent(FluxCapacitor.get().aggregateRepository().loadFor(entityId, defaultType2));
    }

    private static <T> Entity<T> playbackToHandledEvent(Entity<T> entity) {
        DeserializingMessage message = DeserializingMessage.getCurrent();
        if (!Entity.isApplying() && message != null && (message.getMessageType() == MessageType.EVENT || message.getMessageType() == MessageType.NOTIFICATION) && entity.rootAnnotation().eventSourced() && entity.id().toString().equals(Entity.getAggregateId(message))) {
            return entity.playBackToEvent(message.getMessageId());
        }
        return entity;
    }

    public static <T> Entity<T> loadAggregateFor(Object entityId) {
        return FluxCapacitor.loadAggregateFor(entityId, Object.class);
    }

    public static <T> Entity<T> loadEntity(Object entityId) {
        return FluxCapacitor.loadAggregateFor(entityId).getEntity(entityId).orElseGet(() -> FluxCapacitor.loadAggregate(entityId.toString(), Object.class));
    }

    public static <T> Entity<T> loadEntity(Id<T> entityId) {
        return FluxCapacitor.loadAggregateFor(entityId).getEntity(entityId).orElseGet(() -> FluxCapacitor.loadAggregate(entityId));
    }

    public static <T> Optional<T> loadEntityValue(Object entityId) {
        return FluxCapacitor.loadAggregateFor(entityId).getEntity(entityId).map(e -> e.get());
    }

    public static <T> Optional<T> loadEntityValue(Id<T> entityId) {
        return FluxCapacitor.loadAggregateFor(entityId).getEntity(entityId).map(e -> e.get());
    }

    public static CompletableFuture<Void> index(Object object) {
        return FluxCapacitor.get().documentStore().index(object);
    }

    public static CompletableFuture<Void> index(Object object, Object collection) {
        return FluxCapacitor.get().documentStore().index(object, collection);
    }

    public static CompletableFuture<Void> index(Object object, Object id, Object collection) {
        return FluxCapacitor.get().documentStore().index(object, id, collection);
    }

    public static CompletableFuture<Void> index(Object object, Object id, Object collection, Instant timestamp) {
        return FluxCapacitor.get().documentStore().index(object, id, collection, timestamp);
    }

    public static CompletableFuture<Void> index(Object object, Object id, Object collection, Instant begin, Instant end) {
        return FluxCapacitor.get().documentStore().index(object, id, collection, begin, end);
    }

    public static <T> CompletableFuture<Void> index(Collection<? extends T> objects, Object collection, Function<? super T, String> idFunction, Function<? super T, Instant> timestampFunction, Function<? super T, Instant> endFunction) {
        return FluxCapacitor.get().documentStore().index(objects, collection, idFunction, timestampFunction, endFunction);
    }

    public static Search search(Object collection) {
        return FluxCapacitor.get().documentStore().search(collection);
    }

    public static Search search(Object collection, Object ... additionalCollections) {
        return FluxCapacitor.get().documentStore().search(Stream.concat(Stream.of(collection), Arrays.stream(additionalCollections)).toList());
    }

    public static Search search(SearchQuery.Builder queryBuilder) {
        return FluxCapacitor.get().documentStore().search(queryBuilder);
    }

    default public Registration registerHandlers(Object ... handlers) {
        return this.registerHandlers(Arrays.asList(handlers));
    }

    default public Registration registerHandlers(List<?> handlers) {
        return this.apply(f -> {
            Registration local = handlers.stream().flatMap(h -> Stream.of(this.commandGateway().registerHandler(h), this.queryGateway().registerHandler(h), this.eventGateway().registerHandler(h), this.eventStore().registerHandler(h), this.errorGateway().registerHandler(h), this.webRequestGateway().registerHandler(h))).reduce(Registration::merge).orElse(Registration.noOp());
            Registration tracking = Arrays.stream(MessageType.values()).map(t -> this.tracking((MessageType)((Object)((Object)t))).start(this, handlers)).reduce(Registration::merge).orElse(Registration.noOp());
            return tracking.merge(local);
        });
    }

    public void withClock(Clock var1);

    public AggregateRepository aggregateRepository();

    public EventStore eventStore();

    public SnapshotStore snapshotStore();

    public Scheduler scheduler();

    public CommandGateway commandGateway();

    public QueryGateway queryGateway();

    public EventGateway eventGateway();

    public ResultGateway resultGateway();

    public ErrorGateway errorGateway();

    public MetricsGateway metricsGateway();

    public WebRequestGateway webRequestGateway();

    public Tracking tracking(MessageType var1);

    public KeyValueStore keyValueStore();

    public DocumentStore documentStore();

    public UserProvider userProvider();

    public Cache cache();

    public CorrelationDataProvider correlationDataProvider();

    public Serializer serializer();

    public Clock clock();

    public IdentityProvider identityProvider();

    public PropertySource propertySource();

    public Client client();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R> R apply(ThrowingFunction<FluxCapacitor, R> function) {
        FluxCapacitor current = instance.get();
        try {
            instance.set(this);
            R r = function.apply(this);
            return r;
        }
        finally {
            instance.set(current);
        }
    }

    default public void execute(ThrowingConsumer<FluxCapacitor> task) {
        FluxCapacitor current = instance.get();
        try {
            instance.set(this);
            task.accept(this);
        }
        finally {
            instance.set(current);
        }
    }

    public Registration beforeShutdown(Runnable var1);

    @Override
    public void close();
}

