/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.casting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.casting.AnnotatedCaster;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastInspector;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastParameters;
import io.fluxcapacitor.javaclient.common.serialization.casting.Caster;
import io.fluxcapacitor.javaclient.common.serialization.casting.Converter;
import io.fluxcapacitor.javaclient.common.serialization.casting.Downcast;
import io.fluxcapacitor.javaclient.common.serialization.casting.Upcast;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CasterChain<T> {
    private static final Comparator<AnnotatedCaster<?>> upcasterComparator = Comparator.comparing(u -> u.getParameters().revision()).thenComparing(u -> u.getParameters().type());
    private static final Comparator<AnnotatedCaster<?>> downcasterComparator = Comparator.comparing(u -> u.getParameters().revision()).reversed().thenComparing(u -> u.getParameters().type());
    private final Map<DataRevision, AnnotatedCaster<T>> casters;
    private final boolean down;

    public static <T> Caster<SerializedObject<byte[], ?>> createUpcaster(Collection<?> casterCandidates, Converter<T> converter) {
        if (casterCandidates.isEmpty()) {
            return (s, desiredRevision) -> s;
        }
        Caster casterChain = CasterChain.create(casterCandidates, converter.getDataType(), false);
        return (stream, desiredRevision) -> {
            Stream<ConvertingSerializedObject> converted = stream.map(s -> new ConvertingSerializedObject((SerializedObject<byte[], ?>)s, converter));
            Stream<ConvertingSerializedObject> casted = casterChain.cast(converted);
            return casted.map(ConvertingSerializedObject::getResult);
        };
    }

    public static <T, S extends SerializedObject<T, S>> Caster<S> create(Collection<?> casterCandidates, Class<T> dataType, boolean down) {
        if (casterCandidates.isEmpty()) {
            return (s, desiredRevision) -> s;
        }
        List<AnnotatedCaster<T>> upcasterList = CastInspector.getCasters(down ? Downcast.class : Upcast.class, casterCandidates, dataType, down ? downcasterComparator : upcasterComparator);
        CasterChain<T> casterChain = new CasterChain<T>(upcasterList, down);
        return casterChain::cast;
    }

    protected CasterChain(Collection<AnnotatedCaster<T>> casters, boolean down) {
        this.casters = casters.stream().collect(Collectors.toMap(u -> new DataRevision(u.getParameters()), Function.identity(), (a, b) -> {
            throw new DeserializationException(String.format("Failed to create caster chain. Methods '%s' and '%s' both apply to the same data revision.", a, b));
        }));
        this.down = down;
    }

    protected <S extends SerializedObject<T, S>> Stream<S> cast(Stream<S> input, Integer desiredRevision) {
        return this.doCast(input, desiredRevision);
    }

    protected <S extends SerializedObject<T, S>> Stream<S> doCast(Stream<S> input, Integer desiredRevision) {
        return input.flatMap(i -> {
            boolean completed = desiredRevision != null && (this.down ? i.getRevision() <= desiredRevision : i.getRevision() >= desiredRevision);
            return completed ? Stream.of(i) : Optional.ofNullable(this.casters.get(new DataRevision(i.getType(), i.getRevision()))).map(caster -> this.doCast(caster.cast(i), desiredRevision)).orElseGet(() -> Stream.of(i));
        });
    }

    protected static final class DataRevision {
        private final String type;
        private final int revision;

        DataRevision(CastParameters annotation) {
            this(annotation.type(), annotation.revision());
        }

        public String getType() {
            return this.type;
        }

        public int getRevision() {
            return this.revision;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataRevision)) {
                return false;
            }
            DataRevision other = (DataRevision)o;
            if (this.getRevision() != other.getRevision()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRevision();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "CasterChain.DataRevision(type=" + this.getType() + ", revision=" + this.getRevision() + ")";
        }

        @ConstructorProperties(value={"type", "revision"})
        public DataRevision(String type2, int revision) {
            this.type = type2;
            this.revision = revision;
        }
    }

    protected static class ConvertingSerializedObject<T>
    implements SerializedObject<T, ConvertingSerializedObject<T>> {
        private final SerializedObject<byte[], ?> source;
        private final Converter<T> converter;
        private Data<T> data;

        public ConvertingSerializedObject(SerializedObject<byte[], ?> source, Converter<T> converter) {
            this.source = source;
            this.converter = converter;
        }

        @Override
        public Data<T> data() {
            if (this.data == null) {
                this.data = this.converter.convert(this.source.data());
            }
            return this.data;
        }

        @Override
        public String getType() {
            return this.data == null ? this.source.getType() : this.data.getType();
        }

        @Override
        public int getRevision() {
            return this.data == null ? this.source.getRevision() : this.data.getRevision();
        }

        public SerializedObject<byte[], ?> getResult() {
            return this.data == null ? this.source : this.source.withData(this.converter.convertBack(this.data));
        }

        @ConstructorProperties(value={"source", "converter", "data"})
        public ConvertingSerializedObject(SerializedObject<byte[], ?> source, Converter<T> converter, Data<T> data2) {
            this.source = source;
            this.converter = converter;
            this.data = data2;
        }

        public SerializedObject<byte[], ?> getSource() {
            return this.source;
        }

        @Override
        public ConvertingSerializedObject<T> withData(Data<T> data2) {
            return this.data == data2 ? this : new ConvertingSerializedObject<T>(this.source, this.converter, data2);
        }
    }
}

