/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.javaclient.modeling.Entity;
import java.time.Instant;
import java.util.Collection;
import lombok.NonNull;

public abstract class DelegatingEntity<T>
implements Entity<T> {
    protected Entity<T> delegate;

    public DelegatingEntity(@NonNull Entity<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    @Override
    public Object id() {
        return this.delegate.id();
    }

    @Override
    public Collection<?> aliases() {
        return this.delegate.aliases();
    }

    @Override
    public Class<T> type() {
        return this.delegate.type();
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    @Override
    public String idProperty() {
        return this.delegate.idProperty();
    }

    @Override
    public String lastEventId() {
        return this.delegate.lastEventId();
    }

    @Override
    public Long lastEventIndex() {
        return this.delegate.lastEventIndex();
    }

    @Override
    public Instant timestamp() {
        return this.delegate.timestamp();
    }

    @Override
    public long sequenceNumber() {
        return this.delegate.sequenceNumber();
    }

    @Override
    public Entity<T> previous() {
        return this.delegate.previous();
    }

    @Override
    public Collection<? extends Entity<?>> entities() {
        return this.delegate.entities();
    }

    @Override
    public Entity<?> parent() {
        return this.delegate.parent();
    }

    @Override
    public Entity<T> withEventIndex(Long index, String messageId) {
        return this.delegate.withEventIndex(index, messageId);
    }

    @Override
    public Entity<T> withType(Class<T> type2) {
        return this.delegate.withType(type2);
    }

    @Override
    public Entity<T> withSequenceNumber(long sequenceNumber) {
        return this.delegate.withSequenceNumber(sequenceNumber);
    }

    public String toString() {
        return "DelegatingEntity(delegate=" + String.valueOf(this.getDelegate()) + ")";
    }

    public Entity<T> getDelegate() {
        return this.delegate;
    }
}

