/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.ImmutableAggregateRoot;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.UnaryOperator;

public class LazyAggregateRoot<T>
implements AggregateRoot<T> {
    private final ImmutableAggregateRoot<T> delegate;

    public static <T> LazyAggregateRoot<T> from(ImmutableAggregateRoot<T> delegate) {
        return new LazyAggregateRoot<T>(((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)delegate.toBuilder().value(null)).build());
    }

    protected LazyAggregateRoot(ImmutableAggregateRoot<T> delegate) {
        this.delegate = delegate;
        if (!this.rootAnnotation().eventSourced()) {
            throw new IllegalStateException("Cannot create lazy aggregate: event sourcing is disabled.");
        }
    }

    @Override
    public Entity<T> withEventIndex(Long index, String messageId) {
        return this.withDelegate((ImmutableAggregateRoot)this.delegate.withEventIndex(index, messageId));
    }

    @Override
    public long sequenceNumber() {
        return this.delegate.sequenceNumber();
    }

    @Override
    public Instant timestamp() {
        return this.delegate.timestamp();
    }

    @Override
    public Entity<T> previous() {
        return this.delegate.previous();
    }

    @Override
    public T get() {
        Entity<T> start = this.getLastCheckpoint();
        String targetEventId = this.lastEventId();
        AggregateEventStream<DeserializingMessage> events = this.delegate.eventStore().getEvents(this.id(), start.sequenceNumber(), (int)(this.sequenceNumber() - start.sequenceNumber()), this.rootAnnotation().ignoreUnknownEvents());
        Iterator<DeserializingMessage> iterator2 = events.iterator();
        Entity<T> result = start;
        boolean eventReached = false;
        while (iterator2.hasNext()) {
            DeserializingMessage nextEvent = iterator2.next();
            boolean lastEventId = Objects.equals(targetEventId, nextEvent.getMessageId());
            if (eventReached && !lastEventId) break;
            if (lastEventId) {
                eventReached = true;
            }
            result = result.apply(nextEvent);
        }
        return result.get();
    }

    protected Entity<T> getLastCheckpoint() {
        Entity<T> result = this.previous();
        while (result instanceof LazyAggregateRoot) {
            result = result.previous();
        }
        if (result == null) {
            throw new IllegalStateException("Failed to get last checkpoint for aggregate: " + String.valueOf(this.id()));
        }
        return result;
    }

    @Override
    public Collection<?> aliases() {
        return ((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)this.delegate.toBuilder().value(this.get())).build().aliases();
    }

    @Override
    public Collection<? extends Entity<?>> entities() {
        return ((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)this.delegate.toBuilder().value(this.get())).build().entities();
    }

    @Override
    public Object id() {
        return this.delegate.id();
    }

    @Override
    public Class<T> type() {
        return this.delegate.type();
    }

    @Override
    public String idProperty() {
        return this.delegate.idProperty();
    }

    @Override
    public String lastEventId() {
        return this.delegate.lastEventId();
    }

    @Override
    public Long lastEventIndex() {
        return this.delegate.lastEventIndex();
    }

    @Override
    public Entity<T> update(UnaryOperator<T> function) {
        throw new UnsupportedOperationException("This aggregate is read-only.");
    }

    @Override
    public Entity<T> apply(Message eventMessage) {
        throw new UnsupportedOperationException("This aggregate is read-only.");
    }

    @Override
    public Entity<T> commit() {
        throw new UnsupportedOperationException("This aggregate is read-only.");
    }

    @Override
    public Entity<T> withType(Class<T> type2) {
        throw new UnsupportedOperationException("This aggregate is read-only.");
    }

    @Override
    public Entity<T> withSequenceNumber(long sequenceNumber) {
        throw new UnsupportedOperationException("This aggregate is read-only.");
    }

    @Override
    public <E extends Exception> Entity<T> assertLegal(Object command) throws E {
        throw new UnsupportedOperationException("This aggregate is read-only.");
    }

    public LazyAggregateRoot<T> withDelegate(ImmutableAggregateRoot<T> delegate) {
        return this.delegate == delegate ? this : new LazyAggregateRoot<T>(delegate);
    }
}

