/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.modeling.DelegatingEntity;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.ModifiableAggregateRoot;
import java.util.Collection;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class ModifiableEntity<T>
extends DelegatingEntity<T> {
    private final ModifiableAggregateRoot<?> root;

    public ModifiableEntity(Entity<T> delegate, ModifiableAggregateRoot<?> root) {
        super(delegate);
        this.root = root;
    }

    @Override
    public <E extends Exception> Entity<T> assertLegal(Object command) throws E {
        this.root.assertLegal(command);
        return this;
    }

    @Override
    public Entity<T> update(UnaryOperator<T> function) {
        return this.root.update(r -> this.delegate.update(function).root().get()).getEntity(this.id()).orElse(null);
    }

    @Override
    public Entity<T> apply(Message eventMessage) {
        return this.root.apply(eventMessage).getEntity(this.id()).orElse(null);
    }

    @Override
    public Entity<T> commit() {
        return this.root.commit().getEntity(this.id()).orElse(null);
    }

    @Override
    public Entity<T> assertAndApply(Object payloadOrMessage) {
        return this.root.assertAndApply(payloadOrMessage).getEntity(this.id()).orElse(null);
    }

    @Override
    public Collection<? extends Entity<?>> entities() {
        return super.entities().stream().map(e -> new ModifiableEntity<T>(e, this.root)).collect(Collectors.toList());
    }

    @Override
    public Entity<?> parent() {
        return Optional.ofNullable(super.parent()).map(entity -> new ModifiableEntity<T>(entity, this.root)).orElse(null);
    }

    @Override
    public Entity<T> previous() {
        return Optional.ofNullable(super.previous()).map(e -> new ModifiableEntity<T>(e, this.root)).orElse(null);
    }

    public ModifiableAggregateRoot<?> getRoot() {
        return this.root;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifiableEntity)) {
            return false;
        }
        ModifiableEntity other = (ModifiableEntity)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifiableEntity;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "ModifiableEntity(super=" + super.toString() + ")";
    }
}

