/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.GenericGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.tracking.handling.Request;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsGateway
implements MetricsGateway {
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricsGateway.class);
    private final GenericGateway delegate;

    @Override
    public CompletableFuture<Void> publish(Object payload, Metadata metadata2, Guarantee guarantee) {
        return this.delegate.sendAndForget(new Message(payload, metadata2), guarantee);
    }

    @ConstructorProperties(value={"delegate"})
    public DefaultMetricsGateway(GenericGateway delegate) {
        this.delegate = delegate;
    }

    public void sendAndForget(Object message) {
        this.delegate.sendAndForget(message);
    }

    public void sendAndForget(Object payload, Metadata metadata2) {
        this.delegate.sendAndForget(payload, metadata2);
    }

    public void sendAndForget(Object payload, Metadata metadata2, Guarantee guarantee) {
        this.delegate.sendAndForget(payload, metadata2, guarantee);
    }

    public CompletableFuture<Void> sendAndForget(Message message, Guarantee guarantee) {
        return this.delegate.sendAndForget(message, guarantee);
    }

    public void sendAndForget(Object ... messages) {
        this.delegate.sendAndForget(messages);
    }

    public CompletableFuture<Void> sendAndForget(Guarantee guarantee, Object ... messages) {
        return this.delegate.sendAndForget(guarantee, messages);
    }

    public CompletableFuture<Void> sendAndForget(Guarantee guarantee, Message ... messages) {
        return this.delegate.sendAndForget(guarantee, messages);
    }

    public <R> CompletableFuture<R> send(Message message) {
        return this.delegate.send(message);
    }

    public <R> CompletableFuture<R> send(Object message) {
        return this.delegate.send(message);
    }

    public <R> CompletableFuture<R> send(Request<R> message) {
        return this.delegate.send(message);
    }

    public <R> CompletableFuture<R> send(Object payload, Metadata metadata2) {
        return this.delegate.send(payload, metadata2);
    }

    public <R> CompletableFuture<R> send(Request<R> payload, Metadata metadata2) {
        return this.delegate.send(payload, metadata2);
    }

    public CompletableFuture<Message> sendForMessage(Message message) {
        return this.delegate.sendForMessage(message);
    }

    public <R> List<CompletableFuture<R>> send(Object ... messages) {
        return this.delegate.send(messages);
    }

    public List<CompletableFuture<Message>> sendForMessages(Message ... messages) {
        return this.delegate.sendForMessages(messages);
    }

    public <R> R sendAndWait(Object message) {
        return this.delegate.sendAndWait(message);
    }

    public <R> R sendAndWait(Request<R> message) {
        return this.delegate.sendAndWait(message);
    }

    public <R> R sendAndWait(Object payload, Metadata metadata2) {
        return this.delegate.sendAndWait(payload, metadata2);
    }

    public <R> R sendAndWait(Request<R> payload, Metadata metadata2) {
        return this.delegate.sendAndWait(payload, metadata2);
    }

    public <R> R sendAndWait(Message message) {
        return this.delegate.sendAndWait(message);
    }

    public void close() {
        this.delegate.close();
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.delegate.registerHandler(target);
    }

    @Override
    public void setSelfHandlerFilter(HandlerFilter selfHandlerFilter) {
        this.delegate.setSelfHandlerFilter(selfHandlerFilter);
    }

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        return this.delegate.registerHandler(target, handlerFilter);
    }
}

