/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrowingErrorHandler
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ThrowingErrorHandler.class);
    private final boolean logFunctionalErrors;
    private final boolean logTechnicalErrors;

    public ThrowingErrorHandler() {
        this(true, true);
    }

    @Override
    public Object handleError(Throwable error, String errorMessage2, Callable<?> retryFunction) {
        this.logError(error, errorMessage2);
        throw error;
    }

    protected void logError(Throwable error, String errorMessage2) {
        if (!(error instanceof FunctionalException)) {
            if (this.logTechnicalErrors) {
                log.error("{}. Propagating error...", (Object)errorMessage2, (Object)error);
            }
        } else if (this.logFunctionalErrors) {
            log.error("{}. Propagating error...", (Object)errorMessage2, (Object)error);
        }
    }

    @ConstructorProperties(value={"logFunctionalErrors", "logTechnicalErrors"})
    public ThrowingErrorHandler(boolean logFunctionalErrors, boolean logTechnicalErrors) {
        this.logFunctionalErrors = logFunctionalErrors;
        this.logTechnicalErrors = logTechnicalErrors;
    }
}

