/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMessage;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class PayloadFilter
implements MessageFilter<HasMessage> {
    private final Function<Executable, HandleAnnotation> allowedClassProvider = ClientUtils.memoize(e -> ReflectionUtils.getAnnotationAs(e, HandleMessage.class, HandleAnnotation.class).orElse(null));

    @Override
    public boolean test(HasMessage message, Executable executable) {
        Class<?> payloadClass = message.getPayloadClass();
        return Optional.ofNullable(this.allowedClassProvider.apply(executable)).map(a -> a.getAllowedClasses().isEmpty() || a.getAllowedClasses().stream().anyMatch(c -> c.isAssignableFrom(payloadClass))).orElse(true);
    }

    @Override
    public Optional<Class<?>> getLeastSpecificAllowedClass(Executable executable) {
        return Optional.ofNullable(this.allowedClassProvider.apply(executable)).flatMap(a -> a.getAllowedClasses().stream().max(ReflectionUtils.getClassSpecificityComparator()));
    }

    static final class HandleAnnotation {
        private final List<Class<?>> allowedClasses;

        @ConstructorProperties(value={"allowedClasses"})
        public HandleAnnotation(List<Class<?>> allowedClasses) {
            this.allowedClasses = allowedClasses;
        }

        public List<Class<?>> getAllowedClasses() {
            return this.allowedClasses;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandleAnnotation)) {
                return false;
            }
            HandleAnnotation other = (HandleAnnotation)o;
            List<Class<?>> this$allowedClasses = this.getAllowedClasses();
            List<Class<?>> other$allowedClasses = other.getAllowedClasses();
            return !(this$allowedClasses == null ? other$allowedClasses != null : !((Object)this$allowedClasses).equals(other$allowedClasses));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Class<?>> $allowedClasses = this.getAllowedClasses();
            result = result * 59 + ($allowedClasses == null ? 43 : ((Object)$allowedClasses).hashCode());
            return result;
        }

        public String toString() {
            return "PayloadFilter.HandleAnnotation(allowedClasses=" + String.valueOf(this.getAllowedClasses()) + ")";
        }
    }
}

