/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Entry;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.HandlerRepository;
import io.fluxcapacitor.javaclient.modeling.Id;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.tracking.handling.Association;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulHandler
implements Handler<DeserializingMessage> {
    private static final Logger log = LoggerFactory.getLogger(StatefulHandler.class);
    private final Class<?> targetClass;
    private final HandlerMatcher<Object, DeserializingMessage> handlerMatcher;
    private final HandlerRepository repository;
    private final AtomicReference<Object> associationProperties = new AtomicReference();
    private final Function<Executable, Map<String, Association>> methodAssociationProperties = ClientUtils.memoize(m -> ReflectionUtils.getAnnotation(m, Association.class).map(association -> {
        Map associations = Arrays.stream(association.value()).collect(Collectors.toMap(Function.identity(), v -> association, (a, b) -> a));
        if (associations.isEmpty()) {
            log.warn("@Association on {} does not define a property. This is probably a mistake.", m);
        }
        return associations;
    }).orElseGet(Collections::emptyMap));
    private final Function<Executable, Boolean> alwaysAssociateMethods = ClientUtils.memoize(m -> ReflectionUtils.getAnnotation(m, Association.class).filter(Association::always).isPresent());

    @Override
    public Optional<HandlerInvoker> getInvoker(DeserializingMessage message) {
        Collection<Entry<?>> matches;
        if (!this.handlerMatcher.canHandle(message)) {
            return Optional.empty();
        }
        boolean alwaysMatch = this.handlerMatcher.matchingMethods(message).anyMatch(this.alwaysAssociateMethods::apply);
        Collection<Entry<?>> collection = matches = alwaysMatch ? this.repository.getAll() : this.repository.findByAssociation(this.associations(message));
        if (matches.isEmpty()) {
            return this.handlerMatcher.getInvoker(null, message).filter(i -> {
                if (this.alreadyFiltered((HandlerInvoker)i)) return true;
                if (this.canTrackerHandle(message, message.computeRoutingKey().orElseGet(message::getMessageId)) == false) return false;
                return true;
            }).map(i -> new StatefulHandlerInvoker((HandlerInvoker)i, null));
        }
        HandlerInvoker result = null;
        for (Entry<?> entry : matches) {
            Optional<StatefulHandlerInvoker> invoker = this.handlerMatcher.getInvoker(entry.getValue(), message).filter(i -> this.alreadyFiltered((HandlerInvoker)i) || this.canTrackerHandle(message, entry.getId()) != false).map(i -> new StatefulHandlerInvoker((HandlerInvoker)i, entry));
            if (!invoker.isPresent()) continue;
            result = result == null ? (HandlerInvoker)invoker.get() : result.combine(invoker.get());
        }
        return Optional.ofNullable(result);
    }

    protected boolean alreadyFiltered(HandlerInvoker i) {
        return ReflectionUtils.getMethodAnnotation(i.getMethod(), RoutingKey.class).isPresent();
    }

    protected Boolean canTrackerHandle(DeserializingMessage message, String routingKey) {
        return Tracker.current().filter(tracker -> tracker.getConfiguration().ignoreSegment()).map(tracker -> tracker.canHandle(message, routingKey)).orElse(true);
    }

    protected Collection<String> associations(DeserializingMessage message) {
        return Optional.ofNullable(message.getPayload()).stream().flatMap(payload -> Stream.concat(this.handlerMatcher.matchingMethods(message).flatMap(e -> this.methodAssociationProperties.apply((Executable)e).entrySet().stream()), this.getAssociationProperties().entrySet().stream()).filter(entry -> this.includedPayload(payload, (Association)entry.getValue())).flatMap(entry -> ReflectionUtils.readProperty((String)entry.getKey(), payload).or(() -> Optional.ofNullable(message.getMetadata().get(entry.getKey()))).stream())).map(v -> {
            if (v instanceof Id) {
                Id id = (Id)v;
                return id.getFunctionalId();
            }
            return v.toString();
        }).collect(Collectors.toSet());
    }

    protected boolean includedPayload(Object payload, Association association) {
        Class<?> payloadType = payload.getClass();
        if (association.includedClasses().length > 0 && Arrays.stream(association.includedClasses()).noneMatch(c -> c.isAssignableFrom(payloadType))) {
            return false;
        }
        return Arrays.stream(association.excludedClasses()).noneMatch(c -> c.isAssignableFrom(payloadType));
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public HandlerMatcher<Object, DeserializingMessage> getHandlerMatcher() {
        return this.handlerMatcher;
    }

    public HandlerRepository getRepository() {
        return this.repository;
    }

    public Function<Executable, Map<String, Association>> getMethodAssociationProperties() {
        return this.methodAssociationProperties;
    }

    public Function<Executable, Boolean> getAlwaysAssociateMethods() {
        return this.alwaysAssociateMethods;
    }

    @ConstructorProperties(value={"targetClass", "handlerMatcher", "repository"})
    public StatefulHandler(Class<?> targetClass, HandlerMatcher<Object, DeserializingMessage> handlerMatcher, HandlerRepository repository) {
        this.targetClass = targetClass;
        this.handlerMatcher = handlerMatcher;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Association> getAssociationProperties() {
        Object value = this.associationProperties.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.associationProperties;
            synchronized (atomicReference) {
                value = this.associationProperties.get();
                if (value == null) {
                    Map<String, Association> actualValue = ReflectionUtils.getAnnotatedProperties(this.getTargetClass(), Association.class).stream().flatMap(member -> ReflectionUtils.getAnnotation(member, Association.class).stream().flatMap(association -> (association.value().length > 0 ? Arrays.stream(association.value()) : Stream.of(ReflectionUtils.getPropertyName(member))).map(v -> Map.entry(v, association)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
                    value = actualValue == null ? this.associationProperties : actualValue;
                    this.associationProperties.set(value);
                }
            }
        }
        return (Map)(value == this.associationProperties ? null : value);
    }

    protected class StatefulHandlerInvoker
    implements HandlerInvoker {
        private final HandlerInvoker delegate;
        private final Entry<?> currentEntry;

        @Override
        public Object invoke() {
            return HandlerInvoker.super.invoke();
        }

        @Override
        public Object invoke(BiFunction<Object, Object, Object> combiner) {
            Executable executable;
            Object result = this.delegate.invoke(combiner);
            if (this.delegate.getTargetClass().isInstance(result)) {
                if (this.currentEntry == null || !Objects.equals(this.currentEntry.getValue(), result)) {
                    StatefulHandler.this.repository.set(result, this.currentEntry == null ? StatefulHandlerInvoker.computeId(result) : this.currentEntry.getId()).get();
                }
                return null;
            }
            if (result == null && this.delegate.expectResult() && (executable = this.delegate.getMethod()) instanceof Method) {
                Method m = (Method)executable;
                if (this.delegate.getTargetClass().isAssignableFrom(m.getReturnType()) || m.getReturnType().isAssignableFrom(this.delegate.getTargetClass())) {
                    if (this.currentEntry != null) {
                        StatefulHandler.this.repository.delete(this.currentEntry.getId()).get();
                    }
                    return null;
                }
            }
            return result;
        }

        private static Object computeId(Object handler) {
            return ReflectionUtils.getAnnotatedPropertyValue(handler, EntityId.class).orElseGet(FluxCapacitor::generateId);
        }

        public HandlerInvoker getDelegate() {
            return this.delegate;
        }

        public Entry<?> getCurrentEntry() {
            return this.currentEntry;
        }

        @ConstructorProperties(value={"delegate", "currentEntry"})
        public StatefulHandlerInvoker(HandlerInvoker delegate, Entry<?> currentEntry) {
            this.delegate = delegate;
            this.currentEntry = currentEntry;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.getDelegate().getTargetClass();
        }

        @Override
        public Executable getMethod() {
            return this.getDelegate().getMethod();
        }

        @Override
        public <A extends Annotation> A getMethodAnnotation() {
            return this.getDelegate().getMethodAnnotation();
        }

        @Override
        public boolean expectResult() {
            return this.getDelegate().expectResult();
        }

        @Override
        public boolean isPassive() {
            return this.getDelegate().isPassive();
        }

        @Override
        public HandlerInvoker combine(HandlerInvoker second) {
            return this.getDelegate().combine(second);
        }
    }
}

