/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.proxy;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebRequestSettings;
import io.fluxcapacitor.javaclient.web.WebResponse;
import io.fluxcapacitor.javaclient.web.WebUtils;
import io.fluxcapacitor.proxy.ProxySerializer;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyConsumer
implements Consumer<List<SerializedMessage>> {
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyConsumer.class);
    private static final HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(5L)).build();
    protected static final WebRequestSettings defaultSettings = WebRequestSettings.builder().build();
    protected static final Serializer serializer = new ProxySerializer();
    protected final Map<String, Registration> runningConsumers = new ConcurrentHashMap<String, Registration>();
    private final Client client;
    private final String consumerName;
    private final Long minIndex;
    private final AtomicReference<Object> mainConsumer = new AtomicReference();

    public static Registration start(Client client) {
        ReverseProxyConsumer consumer = new ReverseProxyConsumer(client, defaultSettings.getConsumer(), null);
        consumer.runningConsumers.computeIfAbsent(defaultSettings.getConsumer(), c -> consumer.start());
        return () -> {
            Collection<Registration> running = consumer.runningConsumers.values();
            running.forEach(Registration::cancel);
            running.clear();
        };
    }

    protected Registration start() {
        log.info(this.isMainConsumer() ? "Starting consumer {}" : "Starting consumer {} at {}", (Object)this.consumerName, (Object)this.minIndex);
        return DefaultTracker.start((Consumer<List<SerializedMessage>>)this, MessageType.WEBREQUEST, ConsumerConfiguration.builder().name(this.consumerName).minIndex(this.minIndex).threads(4).build(), this.client);
    }

    @Override
    public void accept(List<SerializedMessage> serializedMessages) {
        for (SerializedMessage s : serializedMessages) {
            try {
                WebRequestSettings settings = this.getSettings(s);
                if (this.consumerName.equals(settings.getConsumer())) {
                    URI uri = URI.create(WebRequest.getUrl(s.getMetadata()));
                    if (!uri.isAbsolute()) continue;
                    this.handle(s, uri, settings);
                    continue;
                }
                if (!this.isMainConsumer()) continue;
                this.runningConsumers.computeIfAbsent(settings.getConsumer(), c -> new ReverseProxyConsumer(this.client, (String)c, s.getIndex()).start());
            }
            catch (Throwable e) {
                log.error("Failed to handle external request {}. Continuing..", (Object)s.getMessageId(), (Object)e);
                try {
                    this.sendResponse(this.asWebResponse(e), s);
                }
                catch (Throwable e2) {
                    e2.addSuppressed(e);
                    log.error("Failed to send error response. Continuing..", e2);
                }
            }
        }
    }

    void handle(SerializedMessage request, URI uri, WebRequestSettings settings) {
        HttpRequest httpRequest = this.asHttpRequest(request, uri, settings);
        WebResponse webResponse = this.executeRequest(httpRequest);
        this.sendResponse(webResponse, request);
    }

    HttpRequest asHttpRequest(SerializedMessage request, URI uri, WebRequestSettings settings) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().version(HttpClient.Version.valueOf(settings.getHttpVersion().name())).timeout(settings.getTimeout());
        WebRequest.getHeaders(request.getMetadata()).forEach((name, values2) -> values2.forEach(v -> builder.header((String)name, (String)v)));
        builder.uri(uri).method(WebRequest.getMethod(request.getMetadata()).name(), this.getBodyPublisher(request));
        return builder.build();
    }

    protected WebRequestSettings getSettings(SerializedMessage request) {
        return Optional.ofNullable(request.getMetadata().get("settings", WebRequestSettings.class)).orElse(defaultSettings);
    }

    WebResponse executeRequest(HttpRequest httpRequest) {
        try {
            HttpResponse<byte[]> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
            return this.asWebResponse(response);
        }
        catch (Throwable e) {
            log.error("Failed to handle external request. Returning error.. ", e);
            return this.asWebResponse(e);
        }
    }

    void sendResponse(WebResponse response, SerializedMessage request) {
        SerializedMessage serializedResponse = response.serialize(serializer);
        serializedResponse.setRequestId(request.getRequestId());
        serializedResponse.setTarget(request.getSource());
        this.client.getGatewayClient(MessageType.WEBRESPONSE).append(Guarantee.NONE, serializedResponse);
    }

    WebResponse asWebResponse(HttpResponse<byte[]> response) {
        WebResponse.Builder builder = WebResponse.builder().status(response.statusCode()).payload(response.body());
        response.headers().map().forEach((name, values2) -> values2.forEach(v -> builder.header(WebUtils.fixHeaderName(name), (String)v)));
        return builder.build();
    }

    WebResponse asWebResponse(Throwable e) {
        return WebResponse.builder().status(502).payload(Optional.ofNullable(e.getMessage()).orElse("Exception while handling request in proxy").getBytes()).build();
    }

    HttpRequest.BodyPublisher getBodyPublisher(SerializedMessage request) {
        String type2 = request.getData().getType();
        if (type2 == null || Void.class.getName().equals(type2)) {
            return HttpRequest.BodyPublishers.noBody();
        }
        return HttpRequest.BodyPublishers.ofByteArray(request.getData().getValue());
    }

    @ConstructorProperties(value={"client", "consumerName", "minIndex"})
    private ReverseProxyConsumer(Client client, String consumerName, Long minIndex) {
        this.client = client;
        this.consumerName = consumerName;
        this.minIndex = minIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isMainConsumer() {
        Object value = this.mainConsumer.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.mainConsumer;
            synchronized (atomicReference) {
                value = this.mainConsumer.get();
                if (value == null) {
                    boolean actualValue = this.minIndex == null;
                    value = actualValue;
                    this.mainConsumer.set(value);
                }
            }
        }
        return (Boolean)value;
    }
}

