/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.proxy;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.DisconnectEvent;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.beans.ConstructorProperties;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketEndpoint
extends Endpoint {
    private static final Logger log = LoggerFactory.getLogger(WebsocketEndpoint.class);
    static final String metadataPrefix = "_metadata:";
    static final String clientIdKey = "_clientId";
    static final String trackerIdKey = "_trackerId";
    private final Map<String, Session> openSessions = new ConcurrentHashMap<String, Session>();
    private final Client client;
    private final GatewayClient requestGateway;
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile Registration registration;

    public WebsocketEndpoint(Client client) {
        this.client = client;
        this.requestGateway = client.getGatewayClient(MessageType.WEBREQUEST);
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        this.ensureStarted();
        this.openSessions.put(session.getId(), session);
        session.addMessageHandler(byte[].class, bytes -> this.sendRequest(session, HttpRequestMethod.WS_MESSAGE, (byte[])bytes));
        session.addMessageHandler(String.class, s -> this.sendRequest(session, HttpRequestMethod.WS_MESSAGE, s.getBytes(StandardCharsets.UTF_8)));
        session.addMessageHandler(PongMessage.class, pong -> this.sendRequest(session, HttpRequestMethod.WS_PONG, ObjectUtils.getBytes(pong.getApplicationData())));
        this.sendRequest(session, HttpRequestMethod.WS_OPEN, null);
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        this.openSessions.remove(session.getId());
        this.sendRequest(session, HttpRequestMethod.WS_CLOSE, String.valueOf(closeReason.getCloseCode().getCode()).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void onError(Session session, Throwable error) {
        log.warn("Error in session {}", (Object)session.getId(), (Object)error);
    }

    protected void sendRequest(Session session, HttpRequestMethod method, byte[] payload) {
        Metadata metadata2 = this.getContext(session).metadata().with((Object)"method", (Object)method.name());
        SerializedMessage request = new SerializedMessage(new Data<byte[]>(payload, null, 0, "unknown"), metadata2, FluxCapacitor.generateId(), FluxCapacitor.currentClock().millis());
        request.setSource(this.client.id());
        request.setTarget(this.getContext(session).trackerId());
        this.requestGateway.append(Guarantee.SENT, request);
    }

    protected void handleResultMessages(List<SerializedMessage> resultMessages) {
        resultMessages.forEach(m -> {
            Session session;
            String sessionId = m.getMetadata().get("sessionId");
            if (sessionId != null && (session = this.openSessions.get(sessionId)) != null && session.isOpen()) {
                try {
                    switch (m.getMetadata().getOrDefault("function", "message")) {
                        case "message": {
                            this.sendMessage((SerializedMessage)m, session);
                            break;
                        }
                        case "ping": {
                            this.sendPing((SerializedMessage)m, session);
                            break;
                        }
                        case "close": {
                            this.sendClose((SerializedMessage)m, session);
                        }
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to send websocket result to client (session {})", (Object)session.getId(), (Object)e);
                }
            }
        });
    }

    private void sendMessage(SerializedMessage m, Session session) {
        block15: {
            if (byte[].class.getName().equals(m.getData().getType())) {
                try (OutputStream outputStream = session.getBasicRemote().getSendStream();){
                    outputStream.write(m.getData().getValue());
                    break block15;
                }
            }
            try (Writer writer = session.getBasicRemote().getSendWriter();){
                writer.write(new String(m.getData().getValue(), StandardCharsets.UTF_8));
            }
        }
    }

    private void sendPing(SerializedMessage m, Session session) {
        session.getBasicRemote().sendPing(ByteBuffer.wrap(m.getData().getValue()));
    }

    private void sendClose(SerializedMessage m, Session session) {
        session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode(Integer.parseInt(new String(m.getData().getValue(), StandardCharsets.UTF_8))), null));
    }

    protected void handleDisconnects(List<SerializedMessage> resultMessages) {
        Set clientIds = resultMessages.stream().map(m -> JsonUtils.fromJson(m.getData().getValue(), DisconnectEvent.class)).map(DisconnectEvent::getClientId).collect(Collectors.toSet());
        this.openSessions.values().stream().filter(s -> clientIds.contains(this.getContext((Session)s).clientId())).forEach(session -> {
            try {
                if (session.isOpen()) {
                    session.close(new CloseReason(CloseReason.CloseCodes.GOING_AWAY, "going away"));
                }
            }
            catch (Exception e) {
                log.warn("Failed to close session {}", (Object)session.getId(), (Object)e);
            }
        });
    }

    protected SessionContext getContext(Session session) {
        return (SessionContext)session.getUserProperties().computeIfAbsent("context", c -> {
            SessionContext.SessionContextBuilder contextBuilder = SessionContext.builder();
            LinkedHashMap map = new LinkedHashMap();
            session.getRequestParameterMap().forEach((k, v) -> {
                if (k.startsWith(metadataPrefix)) {
                    String name = k.substring(metadataPrefix.length());
                    map.put(name, (String)v.get(0));
                } else if (k.equals(trackerIdKey)) {
                    contextBuilder.trackerId((String)v.get(0));
                } else if (k.equals(clientIdKey)) {
                    contextBuilder.clientId((String)v.get(0));
                }
            });
            contextBuilder.metadata(Metadata.of(map).with((Object)"sessionId", (Object)session.getId()));
            return contextBuilder.build();
        });
    }

    protected void ensureStarted() {
        if (this.started.compareAndSet(false, true)) {
            this.registration = DefaultTracker.start(this::handleResultMessages, MessageType.WEBRESPONSE, ConsumerConfiguration.builder().name(String.format("%s_%s", this.client.name(), "$websocket-handler")).ignoreSegment(true).clientControlledIndex(true).filterMessageTarget(true).minIndex(IndexUtils.indexFromTimestamp(FluxCapacitor.currentTime().minusSeconds(2L))).build(), this.client).merge(DefaultTracker.start(this::handleDisconnects, MessageType.METRICS, ConsumerConfiguration.builder().name(String.format("%s_%s", this.client.name(), "$websocket-handler")).ignoreSegment(true).clientControlledIndex(true).typeFilter(Pattern.quote(DisconnectEvent.class.getName())).minIndex(IndexUtils.indexFromTimestamp(FluxCapacitor.currentTime().minusSeconds(1L))).build(), this.client));
        }
    }

    public void shutDown() {
        if (this.started.compareAndSet(true, false) && this.registration != null) {
            this.registration.cancel();
            this.openSessions.values().removeIf(s -> {
                try {
                    if (s.isOpen()) {
                        s.close(new CloseReason(CloseReason.CloseCodes.GOING_AWAY, "Redeployment"));
                    }
                }
                catch (Throwable e) {
                    log.warn("Failed to close session when leaving: {}", (Object)s.getId(), (Object)e);
                }
                return true;
            });
        }
    }

    @ConstructorProperties(value={"client", "requestGateway", "registration"})
    public WebsocketEndpoint(Client client, GatewayClient requestGateway, Registration registration) {
        this.client = client;
        this.requestGateway = requestGateway;
        this.registration = registration;
    }

    record SessionContext(Metadata metadata, String clientId, String trackerId) {
        public static SessionContextBuilder builder() {
            return new SessionContextBuilder();
        }

        public static class SessionContextBuilder {
            private Metadata metadata;
            private String clientId;
            private String trackerId;

            SessionContextBuilder() {
            }

            public SessionContextBuilder metadata(Metadata metadata2) {
                this.metadata = metadata2;
                return this;
            }

            public SessionContextBuilder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public SessionContextBuilder trackerId(String trackerId) {
                this.trackerId = trackerId;
                return this;
            }

            public SessionContext build() {
                return new SessionContext(this.metadata, this.clientId, this.trackerId);
            }

            public String toString() {
                return "WebsocketEndpoint.SessionContext.SessionContextBuilder(metadata=" + String.valueOf(this.metadata) + ", clientId=" + this.clientId + ", trackerId=" + this.trackerId + ")";
            }
        }
    }
}

