/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.proxy;

import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WebsocketFilter.class);

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest r = (HttpServletRequest)request;
        chain.doFilter(new HttpServletRequestWrapper(this, r){

            @Override
            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>(r.getParameterMap());
                WebRequest.Builder builder = WebRequest.builder().url(r.getServletPath() + (String)(r.getQueryString() == null ? "" : "?" + r.getQueryString())).method(HttpRequestMethod.valueOf(r.getMethod()));
                r.getHeaderNames().asIterator().forEachRemaining(name -> r.getHeaders((String)name).asIterator().forEachRemaining(value -> builder.header(WebUtils.fixHeaderName(name), (String)value)));
                builder.build().getMetadata().getEntries().forEach((k, v) -> result.put("_metadata:" + k, new String[]{v}));
                return result;
            }
        }, response);
    }
}

