/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.HpackException;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;

final class Hpack {
    private static final byte LOWER_DIFF = 32;
    static final int DEFAULT_TABLE_SIZE = 4096;
    private static final int MAX_INTEGER_OCTETS = 8;
    private static final int[] PREFIX_TABLE = new int[32];
    static final HeaderField[] STATIC_TABLE;
    static final int STATIC_TABLE_LENGTH;

    static int decodeInteger(ByteBuffer source, int n) throws HpackException {
        byte b;
        if (source.remaining() == 0) {
            return -1;
        }
        if (n >= PREFIX_TABLE.length) {
            throw UndertowMessages.MESSAGES.integerEncodedOverTooManyOctets(8);
        }
        int count = 1;
        int sp = source.position();
        int mask = PREFIX_TABLE[n];
        int i = mask & source.get();
        if (i < PREFIX_TABLE[n]) {
            return i;
        }
        int m = 0;
        do {
            if (count++ > 8) {
                throw UndertowMessages.MESSAGES.integerEncodedOverTooManyOctets(8);
            }
            if (source.remaining() == 0) {
                source.position(sp);
                return -1;
            }
            if (m >= PREFIX_TABLE.length) {
                throw UndertowMessages.MESSAGES.integerEncodedOverTooManyOctets(8);
            }
            b = source.get();
            i += (b & 0x7F) * (PREFIX_TABLE[m] + 1);
            m += 7;
        } while ((b & 0x80) == 128);
        return i;
    }

    static void encodeInteger(ByteBuffer source, int value, int n) {
        int twoNminus1 = PREFIX_TABLE[n];
        int pos = source.position() - 1;
        if (value < twoNminus1) {
            source.put(pos, (byte)(source.get(pos) | value));
        } else {
            source.put(pos, (byte)(source.get(pos) | twoNminus1));
            value -= twoNminus1;
            while (value >= 128) {
                source.put((byte)(value % 128 + 128));
                value /= 128;
            }
            source.put((byte)value);
        }
    }

    static byte toLower(byte b) {
        if (b >= 65 && b <= 90) {
            return (byte)(b + 32);
        }
        return b;
    }

    private Hpack() {
    }

    static {
        for (int i = 0; i < 32; ++i) {
            int n = 0;
            for (int j = 0; j < i; ++j) {
                n <<= 1;
                n |= 1;
            }
            Hpack.PREFIX_TABLE[i] = n;
        }
        HeaderField[] fields2 = new HeaderField[62];
        fields2[1] = new HeaderField(new HttpString(":authority"), null);
        fields2[2] = new HeaderField(new HttpString(":method"), "GET");
        fields2[3] = new HeaderField(new HttpString(":method"), "POST");
        fields2[4] = new HeaderField(new HttpString(":path"), "/");
        fields2[5] = new HeaderField(new HttpString(":path"), "/index.html");
        fields2[6] = new HeaderField(new HttpString(":scheme"), "http");
        fields2[7] = new HeaderField(new HttpString(":scheme"), "https");
        fields2[8] = new HeaderField(new HttpString(":status"), "200");
        fields2[9] = new HeaderField(new HttpString(":status"), "204");
        fields2[10] = new HeaderField(new HttpString(":status"), "206");
        fields2[11] = new HeaderField(new HttpString(":status"), "304");
        fields2[12] = new HeaderField(new HttpString(":status"), "400");
        fields2[13] = new HeaderField(new HttpString(":status"), "404");
        fields2[14] = new HeaderField(new HttpString(":status"), "500");
        fields2[15] = new HeaderField(new HttpString("accept-charset"), null);
        fields2[16] = new HeaderField(new HttpString("accept-encoding"), "gzip, deflate");
        fields2[17] = new HeaderField(new HttpString("accept-language"), null);
        fields2[18] = new HeaderField(new HttpString("accept-ranges"), null);
        fields2[19] = new HeaderField(new HttpString("accept"), null);
        fields2[20] = new HeaderField(new HttpString("access-control-allow-origin"), null);
        fields2[21] = new HeaderField(new HttpString("age"), null);
        fields2[22] = new HeaderField(new HttpString("allow"), null);
        fields2[23] = new HeaderField(new HttpString("authorization"), null);
        fields2[24] = new HeaderField(new HttpString("cache-control"), null);
        fields2[25] = new HeaderField(new HttpString("content-disposition"), null);
        fields2[26] = new HeaderField(new HttpString("content-encoding"), null);
        fields2[27] = new HeaderField(new HttpString("content-language"), null);
        fields2[28] = new HeaderField(new HttpString("content-length"), null);
        fields2[29] = new HeaderField(new HttpString("content-location"), null);
        fields2[30] = new HeaderField(new HttpString("content-range"), null);
        fields2[31] = new HeaderField(new HttpString("content-type"), null);
        fields2[32] = new HeaderField(new HttpString("cookie"), null);
        fields2[33] = new HeaderField(new HttpString("date"), null);
        fields2[34] = new HeaderField(new HttpString("etag"), null);
        fields2[35] = new HeaderField(new HttpString("expect"), null);
        fields2[36] = new HeaderField(new HttpString("expires"), null);
        fields2[37] = new HeaderField(new HttpString("from"), null);
        fields2[38] = new HeaderField(new HttpString("host"), null);
        fields2[39] = new HeaderField(new HttpString("if-match"), null);
        fields2[40] = new HeaderField(new HttpString("if-modified-since"), null);
        fields2[41] = new HeaderField(new HttpString("if-none-match"), null);
        fields2[42] = new HeaderField(new HttpString("if-range"), null);
        fields2[43] = new HeaderField(new HttpString("if-unmodified-since"), null);
        fields2[44] = new HeaderField(new HttpString("last-modified"), null);
        fields2[45] = new HeaderField(new HttpString("link"), null);
        fields2[46] = new HeaderField(new HttpString("location"), null);
        fields2[47] = new HeaderField(new HttpString("max-forwards"), null);
        fields2[48] = new HeaderField(new HttpString("proxy-authenticate"), null);
        fields2[49] = new HeaderField(new HttpString("proxy-authorization"), null);
        fields2[50] = new HeaderField(new HttpString("range"), null);
        fields2[51] = new HeaderField(new HttpString("referer"), null);
        fields2[52] = new HeaderField(new HttpString("refresh"), null);
        fields2[53] = new HeaderField(new HttpString("retry-after"), null);
        fields2[54] = new HeaderField(new HttpString("server"), null);
        fields2[55] = new HeaderField(new HttpString("set-cookie"), null);
        fields2[56] = new HeaderField(new HttpString("strict-transport-security"), null);
        fields2[57] = new HeaderField(new HttpString("transfer-encoding"), null);
        fields2[58] = new HeaderField(new HttpString("user-agent"), null);
        fields2[59] = new HeaderField(new HttpString("vary"), null);
        fields2[60] = new HeaderField(new HttpString("via"), null);
        fields2[61] = new HeaderField(new HttpString("www-authenticate"), null);
        STATIC_TABLE = fields2;
        STATIC_TABLE_LENGTH = STATIC_TABLE.length - 1;
    }

    static class HeaderField {
        final HttpString name;
        final String value;
        final int size;

        HeaderField(HttpString name, String value) {
            this.name = name;
            this.value = value;
            this.size = value != null ? 32 + name.length() + value.length() : -1;
        }
    }
}

