/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.handlers.security.SecurityPathMatch;
import io.undertow.servlet.handlers.security.SecurityPathMatches;
import java.util.ArrayList;
import java.util.List;

public class ServletSecurityConstraintHandler
implements HttpHandler {
    private final SecurityPathMatches securityPathMatches;
    private final HttpHandler next;

    public ServletSecurityConstraintHandler(SecurityPathMatches securityPathMatches, HttpHandler next) {
        this.securityPathMatches = securityPathMatches;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        SecurityPathMatch securityMatch = this.securityPathMatches.getSecurityInfo(path, exchange.getRequestMethod().toString());
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        List<SingleConstraintMatch> list = servletRequestContext.getRequiredConstrains();
        if (list == null) {
            list = new ArrayList<SingleConstraintMatch>();
            servletRequestContext.setRequiredConstrains(list);
        }
        list.add(securityMatch.getMergedConstraint());
        TransportGuaranteeType type2 = servletRequestContext.getTransportGuarenteeType();
        if (type2 == null || type2.ordinal() < securityMatch.getTransportGuaranteeType().ordinal()) {
            servletRequestContext.setTransportGuarenteeType(securityMatch.getTransportGuaranteeType());
        }
        UndertowLogger.SECURITY_LOGGER.debugf("Security constraints for request %s are %s", (Object)exchange.getRequestURI(), (Object)list);
        this.next.handleRequest(exchange);
    }
}

