/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.function;

import io.undertow.websockets.core.function.ChannelFunction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ChannelFunctionWritableByteChannel
implements WritableByteChannel {
    private final ChannelFunction[] functions;
    private final WritableByteChannel channel;

    public ChannelFunctionWritableByteChannel(WritableByteChannel channel, ChannelFunction ... functions2) {
        this.channel = channel;
        this.functions = functions2;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        for (ChannelFunction func : this.functions) {
            int pos = src.position();
            func.beforeWrite(src, pos, src.limit() - pos);
        }
        return this.channel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

