/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.jsr.EncodingFactory;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Encoding
implements Closeable {
    private final Map<Class<?>, List<InstanceHandle<? extends Encoder>>> binaryEncoders;
    private final Map<Class<?>, List<InstanceHandle<? extends Decoder>>> binaryDecoders;
    private final Map<Class<?>, List<InstanceHandle<? extends Encoder>>> textEncoders;
    private final Map<Class<?>, List<InstanceHandle<? extends Decoder>>> textDecoders;

    public Encoding(Map<Class<?>, List<InstanceHandle<? extends Encoder>>> binaryEncoders, Map<Class<?>, List<InstanceHandle<? extends Decoder>>> binaryDecoders, Map<Class<?>, List<InstanceHandle<? extends Encoder>>> textEncoders, Map<Class<?>, List<InstanceHandle<? extends Decoder>>> textDecoders) {
        this.binaryEncoders = binaryEncoders;
        this.binaryDecoders = binaryDecoders;
        this.textEncoders = textEncoders;
        this.textDecoders = textDecoders;
    }

    public boolean canEncodeText(Class<?> type2) {
        if (this.textEncoders.containsKey(type2)) {
            return true;
        }
        for (Class<?> key : this.textEncoders.keySet()) {
            if (!key.isAssignableFrom(type2)) continue;
            return true;
        }
        if (EncodingFactory.isPrimitiveOrBoxed(type2)) {
            Class<?> primType = Encoding.boxedType(type2);
            return !this.binaryEncoders.containsKey(primType) && !this.binaryEncoders.containsKey(Object.class);
        }
        return false;
    }

    public boolean canDecodeText(Class<?> type2) {
        if (this.textDecoders.containsKey(type2)) {
            return true;
        }
        if (EncodingFactory.isPrimitiveOrBoxed(type2)) {
            Class<?> primType = Encoding.boxedType(type2);
            return !this.binaryDecoders.containsKey(primType) && !this.binaryEncoders.containsKey(Object.class);
        }
        return false;
    }

    public boolean canEncodeBinary(Class<?> type2) {
        if (this.binaryEncoders.containsKey(type2)) {
            return true;
        }
        for (Class<?> key : this.binaryEncoders.keySet()) {
            if (!key.isAssignableFrom(type2)) continue;
            return true;
        }
        return false;
    }

    public boolean canDecodeBinary(Class<?> type2) {
        return this.binaryDecoders.containsKey(type2);
    }

    public Object decodeText(Class<?> targetType, String message) throws DecodeException {
        if (EncodingFactory.isPrimitiveOrBoxed(targetType)) {
            return this.decodePrimitive(targetType, message);
        }
        List<InstanceHandle<? extends Decoder>> decoders = this.textDecoders.get(targetType);
        if (decoders != null) {
            for (InstanceHandle<? extends Decoder> decoderHandle : decoders) {
                Decoder decoder = decoderHandle.getInstance();
                if (decoder instanceof Decoder.Text) {
                    if (!((Decoder.Text)decoder).willDecode(message)) continue;
                    return ((Decoder.Text)decoder).decode(message);
                }
                try {
                    return ((Decoder.TextStream)decoder).decode(new StringReader(message));
                }
                catch (IOException e) {
                    throw new DecodeException(message, "Could not decode string", (Throwable)e);
                }
            }
        }
        throw new DecodeException(message, "Could not decode string");
    }

    private Object decodePrimitive(Class<?> targetType, String message) throws DecodeException {
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.valueOf(message);
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return Character.valueOf(message.charAt(0));
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return Byte.valueOf(message);
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return Short.valueOf(message);
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.valueOf(message);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.valueOf(message);
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(message);
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.valueOf(message);
        }
        return null;
    }

    public Object decodeBinary(Class<?> targetType, byte[] bytes) throws DecodeException {
        List<InstanceHandle<? extends Decoder>> decoders = this.binaryDecoders.get(targetType);
        if (decoders != null) {
            for (InstanceHandle<? extends Decoder> decoderHandle : decoders) {
                Decoder decoder = decoderHandle.getInstance();
                if (decoder instanceof Decoder.Binary) {
                    if (!((Decoder.Binary)decoder).willDecode(ByteBuffer.wrap(bytes))) continue;
                    return ((Decoder.Binary)decoder).decode(ByteBuffer.wrap(bytes));
                }
                try {
                    return ((Decoder.BinaryStream)decoder).decode(new ByteArrayInputStream(bytes));
                }
                catch (IOException e) {
                    throw new DecodeException(ByteBuffer.wrap(bytes), "Could not decode binary", (Throwable)e);
                }
            }
        }
        throw new DecodeException(ByteBuffer.wrap(bytes), "Could not decode binary");
    }

    public String encodeText(Object o) throws EncodeException {
        Iterator<Object> iterator2;
        List encoders = this.textEncoders.get(o.getClass());
        if (encoders == null) {
            iterator2 = this.textEncoders.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                if (!((Class)entry.getKey()).isAssignableFrom(o.getClass())) continue;
                encoders = (List)entry.getValue();
                break;
            }
        }
        if (encoders != null && (iterator2 = encoders.iterator()).hasNext()) {
            InstanceHandle decoderHandle = (InstanceHandle)iterator2.next();
            Encoder decoder = (Encoder)decoderHandle.getInstance();
            if (decoder instanceof Encoder.Text) {
                return ((Encoder.Text)decoder).encode(o);
            }
            try {
                StringWriter out = new StringWriter();
                ((Encoder.TextStream)decoder).encode(o, out);
                return out.toString();
            }
            catch (IOException e) {
                throw new EncodeException(o, "Could not encode text", e);
            }
        }
        if (EncodingFactory.isPrimitiveOrBoxed(o.getClass())) {
            return o.toString();
        }
        throw new EncodeException(o, "Could not encode text");
    }

    public ByteBuffer encodeBinary(Object o) throws EncodeException {
        Iterator<Object> iterator2;
        List encoders = this.binaryEncoders.get(o.getClass());
        if (encoders == null) {
            iterator2 = this.binaryEncoders.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                if (!((Class)entry.getKey()).isAssignableFrom(o.getClass())) continue;
                encoders = (List)entry.getValue();
                break;
            }
        }
        if (encoders != null && (iterator2 = encoders.iterator()).hasNext()) {
            InstanceHandle decoderHandle = (InstanceHandle)iterator2.next();
            Encoder decoder = (Encoder)decoderHandle.getInstance();
            if (decoder instanceof Encoder.Binary) {
                return ((Encoder.Binary)decoder).encode(o);
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ((Encoder.BinaryStream)decoder).encode(o, out);
                return ByteBuffer.wrap(out.toByteArray());
            }
            catch (IOException e) {
                throw new EncodeException(o, "Could not encode binary", e);
            }
        }
        throw new EncodeException(o, "Could not encode binary");
    }

    @Override
    public void close() {
        for (Map.Entry<Class<?>, List<InstanceHandle<Decoder>>> entry : this.binaryDecoders.entrySet()) {
            for (InstanceHandle<? extends Decoder> instanceHandle : entry.getValue()) {
                instanceHandle.getInstance().destroy();
                instanceHandle.release();
            }
        }
        for (Map.Entry<Class<?>, List<InstanceHandle<Decoder>>> entry : this.textDecoders.entrySet()) {
            for (InstanceHandle<? extends Decoder> instanceHandle : entry.getValue()) {
                instanceHandle.getInstance().destroy();
                instanceHandle.release();
            }
        }
        for (Map.Entry<Class<?>, List<InstanceHandle<Object>>> entry : this.binaryEncoders.entrySet()) {
            for (InstanceHandle<Object> instanceHandle : entry.getValue()) {
                ((Encoder)instanceHandle.getInstance()).destroy();
                instanceHandle.release();
            }
        }
        for (Map.Entry<Class<?>, List<InstanceHandle<Object>>> entry : this.textEncoders.entrySet()) {
            for (InstanceHandle<Object> instanceHandle : entry.getValue()) {
                ((Encoder)instanceHandle.getInstance()).destroy();
                instanceHandle.release();
            }
        }
    }

    private static Class<?> boxedType(Class<?> targetType) {
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return Character.class;
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return Byte.class;
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return Short.class;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.class;
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.class;
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.class;
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.class;
        }
        return targetType;
    }
}

